/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph.model;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConnection;
import org.springframework.ide.eclipse.beans.ui.graph.model.Bean;
import org.springframework.ide.eclipse.beans.ui.graph.model.ConstructorArgument;
import org.springframework.ide.eclipse.beans.ui.graph.model.Property;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;

public class Reference
extends Edge
implements IAdaptable {
    private BeansConnection.BeanType type;
    private Node node;
    private boolean isInner;
    private IResourceModelElement sourceLocation;

    public Reference(BeansConnection.BeanType type, Bean source, Bean target, boolean isInner) {
        this(type, source, target, null, isInner);
    }

    public Reference(BeansConnection.BeanType type, Bean source, Bean target, Node node, boolean isInner) {
        super((Node)source, (Node)target);
        this.type = type;
        this.node = node;
        this.isInner = isInner;
    }

    public Reference(BeansConnection.BeanType type, Bean source, Bean target, Node node, boolean isInner, IResourceModelElement sourceLocation) {
        super((Node)source, (Node)target);
        this.type = type;
        this.node = node;
        this.isInner = isInner;
        this.sourceLocation = sourceLocation;
    }

    public BeansConnection.BeanType getType() {
        return this.type;
    }

    public Bean getSourceBean() {
        return (Bean)this.source;
    }

    public Bean getTargetBean() {
        return (Bean)this.target;
    }

    public Node getNode() {
        return this.node;
    }

    public boolean isInner() {
        return this.isInner;
    }

    public IResourceModelElement getResourceElement() {
        if (this.sourceLocation != null) {
            return this.sourceLocation;
        }
        if (this.node instanceof Property) {
            return ((Property)this.node).getBean().getBean();
        }
        if (this.node instanceof ConstructorArgument) {
            return ((ConstructorArgument)this.node).getBeanConstructorArgument();
        }
        return this.getSourceBean().getBean();
    }

    public int getStartLine() {
        if (this.node instanceof Property) {
            return ((Property)this.node).getBeanProperty().getElementStartLine();
        }
        if (this.node instanceof ConstructorArgument) {
            return ((ConstructorArgument)this.node).getBeanConstructorArgument().getElementStartLine();
        }
        return this.getSourceBean().getStartLine();
    }

    public Object getAdapter(Class adapter) {
        if (this.node instanceof Property) {
            return ((Property)this.node).getAdapter(adapter);
        }
        if (this.node instanceof ConstructorArgument) {
            return ((ConstructorArgument)this.node).getAdapter(adapter);
        }
        return this.getSourceBean().getAdapter(adapter);
    }

    public String toString() {
        return "Reference from '" + this.source + "' to '" + this.target + "'";
    }
}

