/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;

public class RoundedLineBorder
extends LineBorder {
    protected Dimension corner;

    public RoundedLineBorder() {
        this(new Dimension(8, 8));
    }

    public RoundedLineBorder(Dimension corner) {
        this.corner = corner;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        tempRect.setBounds(RoundedLineBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        if (this.getWidth() % 2 == 1) {
            --RoundedLineBorder.tempRect.width;
            --RoundedLineBorder.tempRect.height;
        }
        tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
        graphics.setLineWidth(this.getWidth());
        if (this.getColor() != null) {
            graphics.setForegroundColor(this.getColor());
        }
        graphics.drawRoundRectangle(tempRect, this.corner.width, this.corner.height);
    }

    public void setCornerDimensions(Dimension d) {
        this.corner.width = d.width;
        this.corner.height = d.height;
    }
}

