/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.internal.bestpractices.springiderules;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.ide.eclipse.beans.core.internal.model.Bean;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanReference;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansTypedString;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.core.model.xml.XmlSourceLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UseBeanInheritance
implements IValidationRule<IBean, IBeansValidationContext> {
    private static final int DEFAULT_MIN_NUM_SIMILAR_BEAN_DEFS = 3;
    private static final int DEFAULT_MIN_NUM_SHARED_PROPERTIES = 3;
    public static final String ERROR_ID = "useBeanInheritance";
    private int minNumSimilarBeanDefs = 3;
    private int minNumSharedProperties = 3;
    private final List<IBean> beanList = new ArrayList<IBean>();

    public void setMinNumSharedProperties(int minNumSharedProperties) {
        this.minNumSharedProperties = minNumSharedProperties;
    }

    public void setMinNumSimilarBeanDefs(int minNumSimilarBeanDefs) {
        this.minNumSimilarBeanDefs = minNumSimilarBeanDefs;
    }

    public boolean supports(IModelElement element, IValidationContext context) {
        return element instanceof IBean && this.isBeanSupported((IBean)element);
    }

    public void validate(IBean bean, IBeansValidationContext validationContext, IProgressMonitor progressMonitor) {
        ArrayList<IBean> similarBeanList = new ArrayList<IBean>();
        for (IBean currBean : this.beanList) {
            if (!this.isSimilar(bean, currBean)) continue;
            similarBeanList.add(currBean);
        }
        this.beanList.add(bean);
        if (similarBeanList.size() + 1 >= this.minNumSimilarBeanDefs) {
            String similarBeanNames = this.getBeanNamesString(similarBeanList);
            validationContext.info((IResourceModelElement)bean, ERROR_ID, "Consider using bean inheritance to simplify configuration of the " + bean.getElementName() + " bean. It may be possible to use a parent bean to share configuration with the the following beans: " + similarBeanNames, new ValidationProblemAttribute[0]);
        }
    }

    private boolean constructorArgumentsEqual(IBean bean1, IBean bean2) {
        Set bean1args = bean1.getConstructorArguments();
        Set bean2args = bean2.getConstructorArguments();
        if (bean1args.size() != bean2args.size()) {
            return false;
        }
        for (IBeanConstructorArgument currBean1ConstructorArgument : bean1args) {
            boolean matchFound = false;
            for (IBeanConstructorArgument currBean2ConstructorArgument : bean2args) {
                if (!this.constructorArgumentsEqual(currBean1ConstructorArgument, currBean2ConstructorArgument)) continue;
                matchFound = true;
                break;
            }
            if (matchFound) continue;
            return false;
        }
        return true;
    }

    private boolean constructorArgumentsEqual(IBeanConstructorArgument argument1, IBeanConstructorArgument argument2) {
        return argument1.getElementName().equals(argument2.getElementName()) && this.propertyValuesEqual(argument1.getValue(), argument2.getValue());
    }

    private String getBeanNamesString(List<IBean> similarBeanList) {
        String beanNames = "";
        for (IBean bean : similarBeanList) {
            beanNames = String.valueOf(beanNames) + bean.getElementName() + " ";
        }
        return beanNames;
    }

    private boolean initMethodsEqual(IBean bean1, IBean bean2) {
        if (bean1 instanceof Bean && bean2 instanceof Bean) {
            AbstractBeanDefinition definition1 = (AbstractBeanDefinition)((Bean)bean1).getBeanDefinition();
            AbstractBeanDefinition definition2 = (AbstractBeanDefinition)((Bean)bean2).getBeanDefinition();
            String initMethod1 = definition1.getInitMethodName();
            String initMethod2 = definition2.getInitMethodName();
            if (initMethod1 == null) {
                initMethod1 = "";
            }
            if (initMethod2 == null) {
                initMethod2 = "";
            }
            if (!initMethod1.equals(initMethod2)) {
                return false;
            }
        }
        return true;
    }

    private boolean isBeanSupported(IBean bean) {
        return !(bean.getElementSourceLocation() instanceof XmlSourceLocation) || "http://www.springframework.org/schema/beans".equals(((XmlSourceLocation)bean.getElementSourceLocation()).getNamespaceURI());
    }

    private boolean isSimilar(IBean bean1, IBean bean2) {
        if (!this.isBeanSupported(bean2)) {
            return false;
        }
        if (!this.constructorArgumentsEqual(bean1, bean2)) {
            return false;
        }
        if (!this.initMethodsEqual(bean1, bean2)) {
            return false;
        }
        int matchingPropertyCount = 0;
        for (IBeanProperty currProperty1 : bean1.getProperties()) {
            for (IBeanProperty currProperty2 : bean2.getProperties()) {
                if (!this.propertiesEqual(currProperty1, currProperty2)) continue;
                ++matchingPropertyCount;
            }
        }
        return matchingPropertyCount >= this.minNumSharedProperties;
    }

    private boolean propertiesEqual(IBeanProperty beanProperty1, IBeanProperty beanProperty2) {
        return beanProperty1.getElementName().equals(beanProperty2.getElementName()) && this.propertyValuesEqual(beanProperty1.getValue(), beanProperty2.getValue());
    }

    private boolean propertyValuesEqual(Object value1, Object value2) {
        if (value1 instanceof BeansTypedString && value2 instanceof BeansTypedString) {
            BeansTypedString beansTypedString1 = (BeansTypedString)value1;
            BeansTypedString beansTypedString2 = (BeansTypedString)value2;
            if (beansTypedString1.getString().equals(beansTypedString2.getString())) {
                return true;
            }
        } else if (value1 instanceof BeanReference && value2 instanceof BeanReference) {
            BeanReference beanReference1 = (BeanReference)value1;
            BeanReference beanReference2 = (BeanReference)value2;
            if (beanReference1.getBeanName().equals(beanReference2.getBeanName())) {
                return true;
            }
        }
        return false;
    }
}

