/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.ui;

import com.atlassian.connector.eclipse.ui.AtlassianUiPlugin;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class AtlassianImages {
    private static ImageRegistry imageRegistry;
    private static final URL BASE_URL;
    private static final String T_OBJ = "obj16";
    private static final String T_OVR = "ovr16";
    private static final String T_ECL = "elcl16";
    public static final ImageDescriptor IMG_FLAT_MODE;
    public static final ImageDescriptor IMG_TREE_MODE;
    public static final ImageDescriptor IMG_COMPRESSED_FOLDER_MODE;
    public static final ImageDescriptor IMG_FILE_CHANGED;
    public static final ImageDescriptor IMG_LINK_WITH_EDITOR;
    public static final ImageDescriptor IMG_ECLIPSE_INFO;

    static {
        BASE_URL = AtlassianUiPlugin.getDefault().getBundle().getEntry("/icons/");
        IMG_FLAT_MODE = AtlassianImages.create(T_OBJ, "flatLayout.gif");
        IMG_TREE_MODE = AtlassianImages.create(T_OBJ, "treeLayout.gif");
        IMG_COMPRESSED_FOLDER_MODE = AtlassianImages.create(T_OBJ, "compressedLayout.gif");
        IMG_FILE_CHANGED = AtlassianImages.create(T_OVR, "fileChanged_ov.gif");
        IMG_LINK_WITH_EDITOR = AtlassianImages.create(T_ECL, "synced.gif");
        IMG_ECLIPSE_INFO = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.views.log", (String)"$nl$/icons/obj16/info_st_obj.gif");
    }

    private AtlassianImages() {
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)AtlassianImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (BASE_URL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(BASE_URL, buffer.toString());
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return null;
        }
        ImageRegistry registry = AtlassianImages.getImageRegistry();
        Image image = registry.get("" + imageDescriptor.hashCode());
        if (image == null) {
            image = imageDescriptor.createImage();
            registry.put("" + imageDescriptor.hashCode(), image);
        }
        return image;
    }
}

