/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config.configtypes;

import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.configtypes.ClasspathVariableResolver;
import net.sf.eclipsecs.core.config.configtypes.ConfigurationType;
import net.sf.eclipsecs.core.config.configtypes.MultiPropertyResolver;
import net.sf.eclipsecs.core.config.configtypes.PropertyUtil;
import net.sf.eclipsecs.core.config.configtypes.SystemPropertyResolver;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.CheckstylePluginException;

public class ExternalFileConfigurationType
extends ConfigurationType {
    public static final String KEY_PROTECT_CONFIG = "protect-config-file";
    private static final PropertyResolver DYNAMIC_LOC_RESOLVER;

    static {
        MultiPropertyResolver resolver = new MultiPropertyResolver();
        resolver.addPropertyResolver(new ClasspathVariableResolver());
        resolver.addPropertyResolver(new SystemPropertyResolver());
        DYNAMIC_LOC_RESOLVER = resolver;
    }

    public static String resolveDynamicLocation(String location) throws CheckstylePluginException {
        String newLocation = location;
        try {
            while (PropertyUtil.hasUnresolvedProperties(newLocation)) {
                newLocation = PropertyUtil.replaceProperties(newLocation, DYNAMIC_LOC_RESOLVER);
            }
        }
        catch (CheckstyleException e) {
            CheckstylePluginException.rethrow(e);
        }
        return newLocation;
    }

    protected URL resolveLocation(ICheckConfiguration checkConfiguration) throws IOException {
        String location = checkConfiguration.getLocation();
        try {
            location = ExternalFileConfigurationType.resolveDynamicLocation(location);
        }
        catch (CheckstylePluginException e) {
            CheckstyleLog.log(e);
            throw new IOException(e.getMessage());
        }
        return new File(location).toURI().toURL();
    }

    public boolean isConfigurable(ICheckConfiguration checkConfiguration) {
        boolean isConfigurable = true;
        boolean isProtected = Boolean.valueOf(checkConfiguration.getAdditionalData().get(KEY_PROTECT_CONFIG));
        boolean bl = isConfigurable = !isProtected;
        if (!isProtected) {
            String location = checkConfiguration.getLocation();
            try {
                location = ExternalFileConfigurationType.resolveDynamicLocation(location);
            }
            catch (CheckstylePluginException e) {
                CheckstyleLog.log(e);
                isConfigurable = false;
            }
            isConfigurable = new File(location).canWrite();
        }
        return isConfigurable;
    }
}

