/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.builder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import net.sf.eclipsecs.core.Messages;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectClassLoader
extends ClassLoader {
    private ClassLoader mDelegateClassLoader;
    private final ClassLoader mParentClassLoader;
    private final URLStreamHandlerFactory mStreamHandlerFactory;

    public ProjectClassLoader() {
        this(null);
    }

    public ProjectClassLoader(ClassLoader parent) {
        this(parent, null);
    }

    public ProjectClassLoader(ClassLoader parent, URLStreamHandlerFactory factory) {
        this.mParentClassLoader = parent;
        this.mStreamHandlerFactory = factory;
    }

    public void intializeWithProject(IProject project) {
        URL[] projClassPath = ProjectClassLoader.getProjectClassPath(project);
        this.mDelegateClassLoader = new URLClassLoader(projClassPath, this.mParentClassLoader, this.mStreamHandlerFactory);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.mDelegateClassLoader.loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        return this.mDelegateClassLoader.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.mDelegateClassLoader.getResourceAsStream(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.mDelegateClassLoader.getResources(name);
    }

    private static URL[] getProjectClassPath(IProject project) {
        ArrayList<URL> cpURLs = new ArrayList<URL>();
        ProjectClassLoader.addToClassPath(project, cpURLs, false, new HashSet<IProject>());
        URL[] urls = cpURLs.toArray(new URL[cpURLs.size()]);
        return urls;
    }

    private static void addToClassPath(IProject project, List<URL> cpURLs, boolean isReferenced, Collection<IProject> processedProjects) {
        try {
            if (processedProjects.contains(project)) {
                return;
            }
            processedProjects.add(project);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] cpEntries = javaProject.getResolvedClasspath(true);
            int size = cpEntries.length;
            int i = 0;
            while (i < size) {
                int entryKind = cpEntries[i].getEntryKind();
                if (3 == entryKind) {
                    ProjectClassLoader.handleSourcePath(project, cpURLs, cpEntries[i], javaProject);
                } else if (2 == entryKind) {
                    ProjectClassLoader.handleRefProject(cpURLs, cpEntries[i], processedProjects);
                } else if (1 == entryKind) {
                    ProjectClassLoader.handleLibrary(project, cpURLs, cpEntries[i]);
                } else {
                    CheckstylePluginException ex = new CheckstylePluginException(NLS.bind((String)Messages.errorUnknownClasspathEntry, (Object)cpEntries[i].getPath()));
                    CheckstyleLog.log(ex);
                }
                ++i;
            }
        }
        catch (JavaModelException jme) {
            CheckstyleLog.log(jme);
        }
    }

    private static void handleSourcePath(IProject project, List<URL> cpURLs, IClasspathEntry entry, IJavaProject javapProject) throws JavaModelException {
        IPath sourcePath = entry.getPath();
        IPath outputPath = entry.getOutputLocation();
        if (outputPath == null) {
            sourcePath = javapProject.getOutputLocation();
        } else if (!outputPath.equals((Object)sourcePath)) {
            sourcePath = outputPath;
        }
        IPath projPath = project.getFullPath();
        if (!projPath.equals((Object)sourcePath) && sourcePath.matchingFirstSegments(projPath) > 0) {
            sourcePath = sourcePath.removeFirstSegments(projPath.segmentCount());
            IFolder sourceFolder = project.getFolder(sourcePath);
            sourcePath = sourceFolder.getLocation();
        } else if (projPath.equals((Object)sourcePath)) {
            sourcePath = project.getLocation();
        }
        ProjectClassLoader.handlePath(sourcePath, cpURLs);
    }

    private static void handleRefProject(List<URL> cpURLs, IClasspathEntry entry, Collection<IProject> processedProjects) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject referencedProject = root.getProject(entry.getPath().toString());
        if (referencedProject.exists()) {
            ProjectClassLoader.addToClassPath(referencedProject, cpURLs, true, processedProjects);
        }
    }

    private static void handleLibrary(IProject project, List<URL> cpURLs, IClasspathEntry entry) {
        IPath projPath;
        IPath libPath = entry.getPath();
        if (libPath.matchingFirstSegments(projPath = project.getFullPath()) > 0) {
            if (!(libPath = libPath.removeFirstSegments(projPath.segmentCount())).isEmpty()) {
                IFile file = project.getFile(libPath);
                libPath = file.getLocation();
            } else {
                libPath = project.getLocation();
            }
        } else {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(libPath);
            if (resource != null && resource.exists()) {
                libPath = resource.getLocation();
            }
        }
        ProjectClassLoader.handlePath(libPath, cpURLs);
    }

    private static void handlePath(IPath absolutePath, List<URL> cpURLs) {
        File file;
        if (absolutePath != null && (file = absolutePath.toFile()) != null && file.exists()) {
            try {
                URL url = file.toURI().toURL();
                if (!cpURLs.contains(url)) {
                    cpURLs.add(url);
                }
            }
            catch (MalformedURLException mfe) {
                CheckstyleLog.log(mfe, mfe.getLocalizedMessage());
            }
        }
    }
}

