/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.monitor.usage.preferences;

import com.atlassian.connector.eclipse.internal.monitor.usage.Messages;
import com.atlassian.connector.eclipse.internal.monitor.usage.MonitorUiPlugin;
import com.atlassian.connector.eclipse.internal.monitor.usage.wizards.UsageSubmissionWizard;
import com.atlassian.connector.eclipse.monitor.core.MonitorCorePlugin;
import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.workbench.browser.BrowserUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class UsageDataPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button enableMonitoring;
    private Text logFileText;
    private Button openFile;

    public UsageDataPreferencePage() {
        this.setPreferenceStore(MonitorUiPlugin.getPrefs());
        this.setDescription(Messages.UsageDataPreferencePage_description);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        this.createMonitoringAndFeedbackSection(container);
        this.createCollectorsSection(container);
        this.updateEnablement();
        return container;
    }

    protected void contributeButtons(Composite parent) {
        super.contributeButtons(parent);
        if (parent.getLayout() instanceof GridLayout) {
            GridLayout gl = (GridLayout)parent.getLayout();
            ++gl.numColumns;
        }
        Button uploadNow = new Button(parent, 8);
        uploadNow.setText("Upload Usage Data Submission");
        uploadNow.setToolTipText("Show Usage Data Submission wizard");
        uploadNow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardDialog wizard = new WizardDialog(UsageDataPreferencePage.this.getShell(), (IWizard)new UsageSubmissionWizard());
                wizard.open();
            }
        });
    }

    private void createCollectorsSection(Composite parent) {
        Link details = new Link(parent, 0);
        details.setText(String.format("<A href=\"%s\">Check %s documentation for details.</A>", "http://confluence.atlassian.com/display/IDEPLUGIN/Collecting+Usage+Statistics+for+the+Eclipse+Connector", "Atlassian Connector for Eclipse"));
        details.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserUtil.openUrl((String)e.text, (int)128);
            }
        });
    }

    public void init(IWorkbench workbench) {
    }

    private void updateEnablement() {
        this.logFileText.setEnabled(this.enableMonitoring.getSelection());
        this.openFile.setEnabled(this.enableMonitoring.getSelection());
    }

    private void createMonitoringAndFeedbackSection(Composite parent) {
        this.enableMonitoring = new Button(parent, 32);
        GridDataFactory.fillDefaults().span(2, -1).applyTo((Control)this.enableMonitoring);
        this.enableMonitoring.setText(Messages.UsageDataPreferencePage_enable_monitoring);
        this.enableMonitoring.setSelection(this.getPreferenceStore().getBoolean("com.atlassian.connector.eclipse.monitor.usage.enabled"));
        this.enableMonitoring.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsageDataPreferencePage.this.updateEnablement();
            }
        });
        Composite c = new Composite(parent, 0);
        GridDataFactory.fillDefaults().applyTo((Control)c);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(c);
        Label label = new Label(c, 0);
        label.setText("Log file:");
        final File logFilePath = MonitorCorePlugin.getDefault().getMonitorLogFile();
        this.logFileText = new Text(c, 2048);
        this.logFileText.setText(logFilePath.getPath());
        this.logFileText.setEditable(false);
        GridDataFactory.fillDefaults().grab(true, false).hint(500, -1).applyTo((Control)this.logFileText);
        this.openFile = new Button(c, 8);
        this.openFile.setText("Show file");
        this.openFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(logFilePath.getPath()));
                try {
                    IDE.openEditorOnFileStore((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFileStore)fileStore);
                    ((PreferenceDialog)UsageDataPreferencePage.this.getContainer()).close();
                }
                catch (PartInitException e1) {
                    StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.monitor.ui", "Unable to open editor", (Throwable)e1));
                }
            }
        });
        this.openFile.setEnabled(this.getPreferenceStore().getBoolean("com.atlassian.connector.eclipse.monitor.usage.enabled"));
    }

    public void performDefaults() {
        super.performDefaults();
        this.logFileText.setText(MonitorCorePlugin.getDefault().getMonitorLogFile().getPath());
    }

    public boolean performOk() {
        boolean wasEnabled = this.getPreferenceStore().getBoolean("com.atlassian.connector.eclipse.monitor.usage.enabled");
        if (this.enableMonitoring.getSelection()) {
            if (!wasEnabled) {
                MonitorCorePlugin.getDefault().monitoringEnabled();
            }
            MonitorCorePlugin.getDefault().startMonitoring();
        } else {
            if (wasEnabled) {
                MonitorCorePlugin.getDefault().monitoringDisabled();
            }
            MonitorCorePlugin.getDefault().stopMonitoring();
        }
        this.getPreferenceStore().setValue("com.atlassian.connector.eclipse.monitor.usage.enabled", this.enableMonitoring.getSelection());
        return true;
    }

    public boolean performCancel() {
        this.enableMonitoring.setSelection(this.getPreferenceStore().getBoolean("com.atlassian.connector.eclipse.monitor.usage.enabled"));
        return true;
    }
}

