/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.popup.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.graph.Activator;
import org.tigris.subversion.subclipse.graph.editors.RevisionGraphEditorInput;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;

public class ViewGraphAction
extends WorkbenchWindowAction {
    private IResource selectedResource;

    public void execute(IAction action) throws InterruptedException, InvocationTargetException {
        if (action != null && !action.isEnabled()) {
            action.setEnabled(true);
        } else {
            this.run(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    IResource[] resources = ViewGraphAction.this.getSelectedResources();
                    try {
                        if (resources.length > 0) {
                            String repoPath;
                            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[0]);
                            ISVNRemoteResource remoteResource = svnResource.getBaseResource();
                            if (remoteResource != null && ((repoPath = remoteResource.getRepositoryRelativePath()) == null || repoPath.length() == 0)) {
                                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Policy.bind((String)"ViewGraphAction.0"), (String)Policy.bind((String)"ViewGraphAction.1"));
                                return;
                            }
                            ViewGraphAction.this.getTargetPage().openEditor((IEditorInput)new RevisionGraphEditorInput(resources[0]), "org.tigris.subversion.subclipse.graph.editors.revisionGraphEditor");
                        }
                    }
                    catch (Exception e) {
                        Activator.handleError(e);
                        Activator.showErrorDialog(ViewGraphAction.this.getErrorTitle(), e);
                    }
                }
            }, false, 2);
        }
    }

    protected String getErrorTitle() {
        return Policy.bind((String)"ViewGraphAction.viewGraph");
    }

    protected boolean isEnabledForMultipleResources() {
        return false;
    }

    protected boolean isEnabledForAddedResources() {
        return false;
    }

    protected boolean isEnabledForCopiedResources() {
        return true;
    }

    protected IResource[] getSelectedResources() {
        if (this.selectedResource != null) {
            IResource[] selectedResources = new IResource[]{this.selectedResource};
            return selectedResources;
        }
        return super.getSelectedResources();
    }

    public void setSelectedResource(IResource selectedResource) {
        this.selectedResource = selectedResource;
    }

    protected boolean needsToSaveDirtyEditors() {
        return false;
    }
}

