/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.popup.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.ui.actions.ActionDelegate;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.graph.popup.actions.ViewGraphAction;

public class SynchronizeViewGraphAction
extends ActionDelegate {
    private IStructuredSelection fSelection;

    public void run(IAction action) {
        ISynchronizeModelElement element = (ISynchronizeModelElement)this.fSelection.getFirstElement();
        IResource resource = element.getResource();
        ViewGraphAction viewGraphAction = new ViewGraphAction();
        viewGraphAction.setSelectedResource(resource);
        viewGraphAction.run(null);
    }

    public void selectionChanged(IAction action, ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)sel;
            if (action != null) {
                action.setEnabled(this.isEnabledForSelection());
            }
        }
    }

    private boolean isEnabledForSelection() {
        if (this.fSelection == null || this.fSelection.isEmpty()) {
            return false;
        }
        ISynchronizeModelElement element = (ISynchronizeModelElement)this.fSelection.getFirstElement();
        IResource resource = element.getResource();
        if (resource == null) {
            return false;
        }
        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
        try {
            return svnResource != null && svnResource.isManaged() && !svnResource.isAdded();
        }
        catch (SVNException sVNException) {
            return false;
        }
    }
}

