/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.popup.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.ISVNResource;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.subclipse.graph.cache.Node;
import org.tigris.subversion.subclipse.graph.editors.RevisionGraphEditor;
import org.tigris.subversion.subclipse.graph.editors.RevisionGraphEditorInput;
import org.tigris.subversion.subclipse.ui.dialogs.DifferencesDialog;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class CompareRevisionsAction
extends Action {
    private Node node1;
    private Node node2;
    private RevisionGraphEditor editor;

    public CompareRevisionsAction(Node node1, Node node2, RevisionGraphEditor editor) {
        this.node1 = node1;
        this.node2 = node2;
        this.editor = editor;
        this.setText("Compare...");
    }

    public void run() {
        RevisionGraphEditorInput input = (RevisionGraphEditorInput)this.editor.getEditorInput();
        boolean isFolder = input.getResource() != null && input.getResource().getType() != 1 || input.getRemoteResource() != null && input.getRemoteResource().isFolder();
        ISVNInfo info = input.getInfo();
        try {
            RemoteFolder remoteResource2;
            RemoteFolder remoteResource1;
            ISVNRepositoryLocation repository = SVNProviderPlugin.getPlugin().getRepository(info.getRepository().toString());
            if (isFolder) {
                remoteResource1 = new RemoteFolder(repository, new SVNUrl(String.valueOf(repository.getLocation()) + this.node1.getBranch().getPath()), (SVNRevision)new SVNRevision.Number(this.node1.getRevision()));
                remoteResource2 = new RemoteFolder(repository, new SVNUrl(String.valueOf(repository.getLocation()) + this.node2.getBranch().getPath()), (SVNRevision)new SVNRevision.Number(this.node2.getRevision()));
            } else {
                remoteResource1 = new RemoteFile(repository, new SVNUrl(String.valueOf(repository.getLocation()) + this.node1.getBranch().getPath()), (SVNRevision)new SVNRevision.Number(this.node1.getRevision()));
                remoteResource2 = new RemoteFile(repository, new SVNUrl(String.valueOf(repository.getLocation()) + this.node2.getBranch().getPath()), (SVNRevision)new SVNRevision.Number(this.node2.getRevision()));
            }
            ISVNRemoteResource[] selectedResources = new ISVNRemoteResource[]{remoteResource1, remoteResource2};
            DifferencesDialog dialog = new DifferencesDialog(Display.getDefault().getActiveShell(), null, (ISVNResource[])selectedResources, this.editor.getEditorSite().getPart());
            dialog.setFromRevision(Long.toString(this.node1.getRevision()));
            dialog.setToRevision(Long.toString(this.node2.getRevision()));
            dialog.open();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Compare Revisions", (String)e.getMessage());
        }
    }
}

