/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model.validation.rules;

import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.core.MessageUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.OutputAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.validation.WebflowValidationContext;
import org.springframework.ide.eclipse.webflow.core.internal.model.validation.rules.WebflowValidationRuleUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputAttributeValidationRule
implements IValidationRule<OutputAttribute, WebflowValidationContext> {
    public boolean supports(IModelElement element, IValidationContext context) {
        return element instanceof OutputAttribute && context instanceof WebflowValidationContext;
    }

    public void validate(OutputAttribute attribute, WebflowValidationContext context, IProgressMonitor monitor) {
        if (!StringUtils.hasText((String)attribute.getName())) {
            context.error(attribute, "NO_NAME_ATTRIBUTE", "Element 'output-attribute' requires 'name' attribute", new ValidationProblemAttribute[0]);
        }
        if (StringUtils.hasText((String)attribute.getScope()) && !WebflowValidationRuleUtils.SCOPE_TYPES.contains(attribute.getScope())) {
            context.error(attribute, "INVALID_SCOPE", MessageUtils.format((String)"Invalid scope \"{0}\" specified", (Object)attribute.getScope()), new ValidationProblemAttribute[0]);
        }
    }
}

