/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model.validation.rules;

import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.core.MessageUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.ExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.internal.model.validation.WebflowValidationContext;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionHandlerValidationRule
implements IValidationRule<ExceptionHandler, WebflowValidationContext> {
    public boolean supports(IModelElement element, IValidationContext context) {
        return element instanceof ExceptionHandler && context instanceof WebflowValidationContext;
    }

    public void validate(ExceptionHandler handler, WebflowValidationContext context, IProgressMonitor monitor) {
        if (!StringUtils.hasText((String)handler.getBean())) {
            context.error(handler, "NO_BEAN_ATTRIBUTE", "Element 'exception-handler' requires 'bean' attribute", new ValidationProblemAttribute[0]);
        } else if (!WebflowModelUtils.isReferencedBeanFound(context.getWebflowConfig(), handler.getBean())) {
            context.error(handler, "INVALID_BEAN", MessageUtils.format((String)"Referenced bean \"{0}\" cannot be found", (Object)handler.getBean()), new ValidationProblemAttribute[0]);
        }
    }
}

