/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model.validation.rules;

import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.core.MessageUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.Attribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.validation.WebflowValidationContext;
import org.springframework.ide.eclipse.webflow.core.internal.model.validation.rules.WebflowValidationRuleUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeValidationRule
implements IValidationRule<Attribute, WebflowValidationContext> {
    public boolean supports(IModelElement element, IValidationContext context) {
        return element instanceof Attribute && context instanceof WebflowValidationContext;
    }

    public void validate(Attribute attribute, WebflowValidationContext context, IProgressMonitor monitor) {
        if (context.isVersion1()) {
            if (!StringUtils.hasText((String)attribute.getName())) {
                context.error(attribute, "NO_NAME_ATTRIBUTE", "Element 'attribute' requires 'name' attribute", new ValidationProblemAttribute[0]);
            }
            if (StringUtils.hasText((String)attribute.getType()) && WebflowValidationRuleUtils.getJavaType(attribute.getType(), context) == null) {
                context.error(attribute, "NO_TYPE_FOUND", MessageUtils.format((String)"Attribute 'type' \"{0}\" cannot be resolved", (Object)attribute.getType()), new ValidationProblemAttribute[0]);
            }
            if (!StringUtils.hasText((String)attribute.getValue())) {
                context.error(attribute, "NO_VALUE_ATTRIBUTE", "Element 'attribute' requires a 'value'", new ValidationProblemAttribute[0]);
            }
        } else {
            if (!StringUtils.hasText((String)attribute.getName())) {
                context.error(attribute, "NO_NAME_ATTRIBUTE", "Element 'attribute' requires 'name' attribute", new ValidationProblemAttribute[0]);
            }
            if (StringUtils.hasText((String)attribute.getType()) && WebflowValidationRuleUtils.getJavaType(attribute.getType(), context) == null) {
                context.error(attribute, "NO_TYPE_FOUND", MessageUtils.format((String)"Attribute 'type' \"{0}\" cannot be resolved", (Object)attribute.getType()), new ValidationProblemAttribute[0]);
            }
        }
    }
}

