/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model.update;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;
import org.springframework.ide.eclipse.webflow.core.model.update.IWebflowModelUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebflowModelUpdater {
    private static final List<IWebflowModelUpdate> UPDATES = new ArrayList<IWebflowModelUpdate>();

    public static void updateModel(Collection<IWebflowProject> projects) {
        for (IWebflowProject project : projects) {
            WebflowModelUpdater.updateProject(project);
        }
    }

    public static void updateProject(IWebflowProject project) {
        for (IWebflowModelUpdate update : UPDATES) {
            project.getConfigs();
            if (!update.requiresUpdate(project)) continue;
            UpdateJob job = new UpdateJob(project, update);
            job.setPriority(40);
            job.setRule((ISchedulingRule)project.getProject());
            job.schedule();
        }
    }

    private static class UpdateJob
    extends Job {
        private final IWebflowProject project;
        private final IWebflowModelUpdate update;

        public UpdateJob(IWebflowProject project, IWebflowModelUpdate update) {
            super("Updating Spring Project '" + project.getElementName() + "' with update '" + update.getName() + "'");
            this.project = project;
            this.update = update;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.update.updateProject(this.project);
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

