/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model.update;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.webflow.core.Activator;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowProject;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;
import org.springframework.ide.eclipse.webflow.core.model.update.IWebflowModelUpdate;

public class UpdateFor252
implements IWebflowModelUpdate {
    public String getName() {
        return "Updating Spring model to 2.5.2 version";
    }

    public boolean requiresUpdate(IWebflowProject webflowProject) {
        return webflowProject.getProject().getFile(".springWebflow").exists();
    }

    public void updateProject(IWebflowProject webflowProject) {
        IFile oldFile = webflowProject.getProject().getFile(".springWebflow");
        IFile newFile = webflowProject.getProject().getFile(".springWebflow");
        if (oldFile.exists() && !newFile.exists()) {
            ((WebflowProject)webflowProject).saveDescription();
            try {
                if (SpringCoreUtils.validateEdit((IFile[])new IFile[]{oldFile})) {
                    oldFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                Activator.log("Problem deleting old '.springWebflow'", e);
            }
        }
    }
}

