/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model.resources;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.internal.model.resources.ISpringResourceChangeEvents;
import org.springframework.ide.eclipse.core.internal.model.resources.SpringResourceChangeListener;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.internal.model.resources.IWebflowResourceChangeEvents;

public class WebflowResourceChangeListener
extends SpringResourceChangeListener {
    private IWebflowResourceChangeEvents events;

    public WebflowResourceChangeListener(IWebflowResourceChangeEvents events) {
        super((ISpringResourceChangeEvents)events);
        this.events = events;
    }

    protected IResourceDeltaVisitor getVisitor(int eventType) {
        return new WebflowResourceVisitor(eventType);
    }

    protected class WebflowResourceVisitor
    extends SpringResourceChangeListener.SpringResourceVisitor {
        public WebflowResourceVisitor(int eventType) {
            super((SpringResourceChangeListener)WebflowResourceChangeListener.this, eventType);
        }

        protected boolean resourceAdded(IResource resource) {
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (this.isProjectDescriptionFile((IResource)file)) {
                    if (SpringCoreUtils.isSpringProject((IResource)file)) {
                        WebflowResourceChangeListener.this.events.projectDescriptionChanged(file, this.eventType);
                    }
                } else if (WebflowModelUtils.isWebflowConfig((IResource)file)) {
                    WebflowResourceChangeListener.this.events.configAdded(file, this.eventType);
                }
                return false;
            }
            return super.resourceAdded(resource);
        }

        protected boolean resourceChanged(IResource resource, int flags) {
            if (resource instanceof IFile) {
                if ((flags & 0x100) != 0) {
                    IFile file = (IFile)resource;
                    if (this.isProjectDescriptionFile((IResource)file)) {
                        if (SpringCoreUtils.isSpringProject((IResource)file)) {
                            WebflowResourceChangeListener.this.events.projectDescriptionChanged(file, this.eventType);
                        }
                    } else if (WebflowModelUtils.isWebflowConfig((IResource)file)) {
                        WebflowResourceChangeListener.this.events.configChanged(file, this.eventType);
                    }
                }
                return false;
            }
            return super.resourceChanged(resource, flags);
        }

        protected boolean resourceRemoved(IResource resource) {
            if (resource instanceof IFile) {
                if (WebflowModelUtils.isWebflowConfig(resource)) {
                    WebflowResourceChangeListener.this.events.configRemoved((IFile)resource, this.eventType);
                }
                return false;
            }
            return super.resourceRemoved(resource);
        }

        private boolean isProjectDescriptionFile(IResource resource) {
            return resource != null && resource.isAccessible() && resource.getType() == 1 && resource.getFullPath().segmentCount() == 2 && resource.getName().equals(".springWebflow");
        }
    }
}

