/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractState;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractTransitionableFrom;
import org.springframework.ide.eclipse.webflow.core.internal.model.ActionState;
import org.springframework.ide.eclipse.webflow.core.internal.model.DecisionState;
import org.springframework.ide.eclipse.webflow.core.internal.model.EndState;
import org.springframework.ide.eclipse.webflow.core.internal.model.EntryActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.ExitActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.GlobalTransitions;
import org.springframework.ide.eclipse.webflow.core.internal.model.Import;
import org.springframework.ide.eclipse.webflow.core.internal.model.InlineFlowState;
import org.springframework.ide.eclipse.webflow.core.internal.model.InputAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.InputMapper;
import org.springframework.ide.eclipse.webflow.core.internal.model.OutputAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.OutputMapper;
import org.springframework.ide.eclipse.webflow.core.internal.model.SubflowState;
import org.springframework.ide.eclipse.webflow.core.internal.model.Variable;
import org.springframework.ide.eclipse.webflow.core.internal.model.ViewState;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IAttribute;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IDecisionState;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IGlobalTransitions;
import org.springframework.ide.eclipse.webflow.core.model.IIf;
import org.springframework.ide.eclipse.webflow.core.model.IIfTransition;
import org.springframework.ide.eclipse.webflow.core.model.IImport;
import org.springframework.ide.eclipse.webflow.core.model.IInlineFlowState;
import org.springframework.ide.eclipse.webflow.core.model.IInputAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IInputMapper;
import org.springframework.ide.eclipse.webflow.core.model.IOutputAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IOutputMapper;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IStateTransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableFrom;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableTo;
import org.springframework.ide.eclipse.webflow.core.model.IVar;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebflowState
extends AbstractTransitionableFrom
implements IWebflowState,
ICloneableModelElement<IWebflowState> {
    private final IWebflowConfig webflowConfig;
    private List<IImport> imports;
    private IInputMapper inputMapper;
    private IOutputMapper outputMapper;
    private List<IState> states;
    private List<IInlineFlowState> inlineFlows;
    private List<IVar> vars;
    private IGlobalTransitions globalTransition;
    private List<IInputAttribute> inputAttributes = null;
    private List<IOutputAttribute> outputAttributes = null;

    public WebflowState(IWebflowConfig webflowConfig) {
        this.webflowConfig = webflowConfig;
    }

    @Override
    public void init(IDOMNode node, IWebflowModelElement parent) {
        super.init(node, parent);
        this.imports = new ArrayList<IImport>();
        this.inlineFlows = new ArrayList<IInlineFlowState>();
        this.states = new ArrayList<IState>();
        this.vars = new ArrayList<IVar>();
        this.inputAttributes = new ArrayList<IInputAttribute>();
        this.outputAttributes = new ArrayList<IOutputAttribute>();
        if (node != null) {
            NodeList children = node.getChildNodes();
            if (children != null && children.getLength() > 0) {
                int i = 0;
                while (i < children.getLength()) {
                    InputAttribute attr;
                    Import im;
                    AbstractState state;
                    IDOMNode child = (IDOMNode)children.item(i);
                    if ("action-state".equals(child.getLocalName())) {
                        state = new ActionState();
                        ((ActionState)state).init(child, this);
                        this.states.add(state);
                    } else if ("view-state".equals(child.getLocalName())) {
                        state = new ViewState();
                        ((ViewState)state).init(child, this);
                        this.states.add(state);
                    } else if ("decision-state".equals(child.getLocalName())) {
                        state = new DecisionState();
                        ((DecisionState)state).init(child, this);
                        this.states.add(state);
                    } else if ("end-state".equals(child.getLocalName())) {
                        state = new EndState();
                        ((EndState)state).init(child, this);
                        this.states.add(state);
                    } else if ("subflow-state".equals(child.getLocalName())) {
                        state = new SubflowState();
                        ((SubflowState)state).init(child, this);
                        this.states.add(state);
                    } else if ("inline-flow".equals(child.getLocalName())) {
                        state = new InlineFlowState();
                        ((InlineFlowState)state).init(child, this);
                        this.inlineFlows.add((IInlineFlowState)((Object)state));
                    } else if ("import".equals(child.getLocalName())) {
                        im = new Import();
                        im.init(child, this);
                        this.imports.add(im);
                    } else if ("bean-import".equals(child.getLocalName())) {
                        im = new Import();
                        im.init(child, this);
                        this.imports.add(im);
                    } else if ("var".equals(child.getLocalName())) {
                        Variable var = new Variable();
                        var.init(child, this);
                        this.vars.add(var);
                    } else if ("start-actions".equals(child.getLocalName())) {
                        this.entryActions = new EntryActions();
                        this.entryActions.init(child, this);
                    } else if ("on-start".equals(child.getLocalName())) {
                        this.entryActions = new EntryActions();
                        this.entryActions.init(child, this);
                    } else if ("end-actions".equals(child.getLocalName())) {
                        this.exitActions = new ExitActions();
                        this.exitActions.init(child, this);
                    } else if ("on-end".equals(child.getLocalName())) {
                        this.exitActions = new ExitActions();
                        this.exitActions.init(child, this);
                    } else if ("input-mapper".equals(child.getLocalName())) {
                        this.inputMapper = new InputMapper();
                        this.inputMapper.init(child, this);
                    } else if ("output-mapper".equals(child.getLocalName())) {
                        this.outputMapper = new OutputMapper();
                        this.outputMapper.init(child, this);
                    } else if ("global-transitions".equals(child.getLocalName())) {
                        this.globalTransition = new GlobalTransitions();
                        this.globalTransition.init(child, this);
                    } else if ("input".equals(child.getLocalName())) {
                        attr = new InputAttribute();
                        attr.init(child, this);
                        this.inputAttributes.add(attr);
                    } else if ("output".equals(child.getLocalName())) {
                        attr = new OutputAttribute();
                        attr.init(child, this);
                        this.outputAttributes.add((IOutputAttribute)((Object)attr));
                    }
                    ++i;
                }
            }
            for (IState state : this.states) {
                if (!(state instanceof ITransitionableFrom)) continue;
                for (ITransition trans : ((ITransitionableFrom)state).getOutputTransitions()) {
                    if (!(trans instanceof IStateTransition) || ((IStateTransition)trans).getToState() == null) continue;
                    ((IStateTransition)trans).getToState().getInputTransitions().add(trans);
                }
                if (!(state instanceof IDecisionState)) continue;
                for (IIf i : ((IDecisionState)state).getIfs()) {
                    if (i.getThenTransition() != null && i.getThenTransition().getToState() != null && !i.getThenTransition().getToState().getInputTransitions().contains(i.getThenTransition())) {
                        i.getThenTransition().getToState().getInputTransitions().add(i.getThenTransition());
                    }
                    if (i.getElseTransition() == null || i.getElseTransition().getToState() == null || i.getElseTransition().getToState().getInputTransitions().contains(i.getElseTransition())) continue;
                    i.getElseTransition().getToState().getInputTransitions().add(i.getElseTransition());
                }
            }
        }
    }

    @Override
    public void addImport(IImport ip) {
        if (!this.getImports().contains(ip)) {
            this.getImports().add(ip);
            WebflowModelXmlUtils.insertNode((Node)ip.getNode(), (Node)this.node);
            super.firePropertyChange("add_children", new Integer(this.getStates().indexOf(ip)), ip);
        }
    }

    @Override
    public void addImport(IImport pm, int i) {
        if (!this.getImports().contains(pm)) {
            int refIndex = i;
            if (i >= this.vars.size()) {
                refIndex = this.vars.size() - 1;
            }
            IVar refState = this.vars.get(refIndex);
            this.getImports().add(i, pm);
            WebflowModelXmlUtils.insertBefore((Node)pm.getNode(), (Node)refState.getNode());
            super.firePropertyChange("add_children", new Integer(i), pm);
        }
    }

    @Override
    public void addState(IState state) {
        if (!this.getStates().contains(state)) {
            WebflowModelXmlUtils.insertNode((Node)state.getNode(), (Node)this.node);
            this.states.add(state);
            super.firePropertyChange("add_children", new Integer(this.states.indexOf(state)), state);
            if (state instanceof ITransitionableTo) {
                for (IState s : this.states) {
                    if (s instanceof ITransitionableFrom) {
                        for (ITransition trans : ((ITransitionableFrom)s).getOutputTransitions()) {
                            if (!(trans instanceof IStateTransition)) continue;
                            IStateTransition stateTrans = (IStateTransition)trans;
                            if (!state.getId().equals(stateTrans.getToStateId()) || ((ITransitionableTo)state).getInputTransitions().contains(trans)) continue;
                            stateTrans.getFromState().fireStructureChange("outputs", stateTrans);
                            ((ITransitionableTo)state).addInputTransition(trans);
                        }
                    }
                    if (!(s instanceof IDecisionState)) continue;
                    for (IIf i : ((IDecisionState)s).getIfs()) {
                        IIfTransition ifTrans;
                        if (i.getThenTransition() != null) {
                            ifTrans = i.getThenTransition();
                            if (state.getId().equals(ifTrans.getToStateId()) && !((ITransitionableTo)state).getInputTransitions().contains(ifTrans)) {
                                ((IWebflowModelElement)ifTrans.getElementParent()).fireStructureChange("outputs", ifTrans);
                                ((ITransitionableTo)state).addInputTransition(ifTrans);
                            }
                        }
                        if (i.getElseTransition() == null) continue;
                        ifTrans = i.getElseTransition();
                        if (!state.getId().equals(ifTrans.getToStateId()) || ((ITransitionableTo)state).getInputTransitions().contains(ifTrans)) continue;
                        ((IWebflowModelElement)ifTrans.getElementParent()).fireStructureChange("outputs", ifTrans);
                        ((ITransitionableTo)state).addInputTransition(ifTrans);
                    }
                }
            }
        }
    }

    @Override
    public void addState(IState state, int i) {
        if (!this.getStates().contains(state)) {
            int refIndex = i;
            if (i >= this.states.size()) {
                refIndex = this.states.size() - 1;
            }
            IState refState = this.getStates().get(refIndex);
            this.states.add(i, state);
            WebflowModelXmlUtils.insertBefore((Node)state.getNode(), (Node)refState.getNode());
            super.firePropertyChange("add_children", new Integer(i), state);
        }
    }

    @Override
    public void addVar(IVar state) {
        if (!this.getVars().contains(state)) {
            this.getVars().add(state);
            WebflowModelXmlUtils.insertNode((Node)state.getNode(), (Node)this.node);
            super.firePropertyChange("add_children", new Integer(this.getVars().indexOf(state)), state);
        }
    }

    @Override
    public void addVar(IVar state, int i) {
        if (!this.getVars().contains(state)) {
            int refIndex = i;
            if (i >= this.vars.size()) {
                refIndex = this.vars.size() - 1;
            }
            IVar refState = this.vars.get(refIndex);
            this.getVars().add(i, state);
            WebflowModelXmlUtils.insertBefore((Node)state.getNode(), (Node)refState.getNode());
            super.firePropertyChange("add_children", new Integer(i), state);
        }
    }

    @Override
    public List<IImport> getImports() {
        return this.imports;
    }

    @Override
    public IInputMapper getInputMapper() {
        return this.inputMapper;
    }

    @Override
    public IOutputMapper getOutputMapper() {
        return this.outputMapper;
    }

    @Override
    public IState getStartState() {
        if (this.hasStartState()) {
            if (WebflowModelXmlUtils.isVersion1Flow(this)) {
                List<IDOMNode> nodes = this.getChildrenNodeByTagName("start-state");
                IDOMNode node = nodes.get(0);
                return WebflowModelXmlUtils.getStateById(this, this.getAttribute(node, "idref"));
            }
            IState state = WebflowModelXmlUtils.getStateById(this, this.getAttribute(this.node, "start-state"));
            if (state != null) {
                return state;
            }
            return this.getStates().get(0);
        }
        return null;
    }

    @Override
    public List<IState> getStates() {
        return this.states;
    }

    @Override
    public List<IInlineFlowState> getInlineFlowStates() {
        return this.inlineFlows;
    }

    @Override
    public List<IVar> getVars() {
        return this.vars;
    }

    @Override
    public boolean hasStartState() {
        if (WebflowModelXmlUtils.isVersion1Flow(this)) {
            List<IDOMNode> nodes = this.getChildrenNodeByTagName("start-state");
            return nodes != null && nodes.size() == 1;
        }
        return this.getAttribute("start-state") != null || this.getStates().size() > 0;
    }

    @Override
    public boolean isStartState(IState state) {
        return this.hasStartState() && state.getId() != null && state.equals(this.getStartState());
    }

    @Override
    public void moveImport(IImport im, int i) {
    }

    @Override
    public void moveState(IState state, int i) {
        if (!this.getStates().contains(state)) {
            int refIndex = i;
            if (i >= this.states.size()) {
                refIndex = this.states.size() - 1;
            }
            IState refState = this.getStates().get(refIndex);
            this.removeState(state);
            this.states.add(i, state);
            WebflowModelXmlUtils.insertBefore((Node)state.getNode(), (Node)refState.getNode());
            super.firePropertyChange("move_children", new Integer(i), state);
        }
    }

    @Override
    public void moveVar(IVar state, int i) {
    }

    @Override
    public void removeImport(IImport im) {
        if (this.getImports().contains(im)) {
            this.getImports().remove(im);
            if (im.getNode().getParentNode() != null) {
                this.getNode().removeChild((Node)im.getNode());
            }
            super.fireStructureChange("remove_children", im);
        }
    }

    @Override
    public void removeState(IState state) {
        if (this.getStates().contains(state)) {
            this.states.remove(state);
            if (state.getNode().getParentNode() != null) {
                this.getNode().removeChild((Node)state.getNode());
            }
            super.fireStructureChange("remove_children", state);
        }
    }

    @Override
    public void removeVar(IVar state) {
        if (this.getVars().contains(state)) {
            this.getVars().remove(state);
            if (state.getNode().getParentNode() != null) {
                this.getNode().removeChild((Node)state.getNode());
            }
            super.fireStructureChange("remove_children", state);
        }
    }

    @Override
    public void setStartState(IState state) {
        IState oldState = this.getStartState();
        if (WebflowModelXmlUtils.isVersion1Flow(this)) {
            List<IDOMNode> nodes = this.getChildrenNodeByTagName("start-state");
            if (nodes != null && nodes.size() > 0) {
                IDOMNode node = nodes.get(0);
                this.setAttribute(node, "idref", state.getId());
            } else {
                Element startNode = this.getNode().getOwnerDocument().createElement("start-state");
                WebflowModelXmlUtils.insertNode(startNode, (Node)this.node);
                this.setAttribute((IDOMNode)startNode, "idref", state.getId());
            }
        } else {
            this.setAttribute("start-state", state.getId());
        }
        if (oldState != null) {
            oldState.fireStructureChange("properties", oldState);
        }
        state.fireStructureChange("properties", state);
    }

    @Override
    public void createNew(IWebflowState parent) {
        IDOMNode node = (IDOMNode)parent.getNode().getOwnerDocument().createElement("flow");
        this.init(node, parent);
    }

    @Override
    public IWebflowState cloneModelElement() {
        WebflowState state = new WebflowState(this.webflowConfig);
        state.init((IDOMNode)this.node.cloneNode(true), this.parent);
        return state;
    }

    @Override
    public void applyCloneValues(IWebflowState element) {
        if (element != null) {
            if (this.node.getParentNode() != null) {
                this.parent.getNode().replaceChild((Node)element.getNode(), (Node)this.node);
            }
            this.init(element.getNode(), this.parent);
        }
    }

    @Override
    public void setOutputMapper(IOutputMapper outputMapper) {
        if (this.outputMapper != null) {
            this.getNode().removeChild((Node)this.outputMapper.getNode());
        }
        this.outputMapper = outputMapper;
        if (outputMapper != null) {
            WebflowModelXmlUtils.insertNode((Node)outputMapper.getNode(), (Node)this.getNode());
        }
        super.fireStructureChange("add_children", outputMapper);
    }

    @Override
    public void setInputMapper(IInputMapper inputMapper) {
        if (this.inputMapper != null) {
            this.getNode().removeChild((Node)this.inputMapper.getNode());
        }
        this.inputMapper = inputMapper;
        if (inputMapper != null) {
            WebflowModelXmlUtils.insertNode((Node)inputMapper.getNode(), (Node)this.getNode());
        }
        super.fireStructureChange("add_children", inputMapper);
    }

    @Override
    public void addInlineFlowState(IInlineFlowState state) {
        if (!this.inlineFlows.contains(state)) {
            WebflowModelXmlUtils.insertNode((Node)state.getNode(), (Node)this.node);
            this.inlineFlows.add(state);
            super.firePropertyChange("add_children", new Integer(this.inlineFlows.indexOf(state)), state);
        }
    }

    @Override
    public void addInlineFlowState(IInlineFlowState state, int i) {
        if (!this.inlineFlows.contains(state)) {
            int refIndex = i;
            if (i >= this.inlineFlows.size()) {
                refIndex = this.inlineFlows.size();
            }
            IState refState = this.getStates().get(refIndex);
            this.inlineFlows.add(i, state);
            WebflowModelXmlUtils.insertBefore((Node)state.getNode(), (Node)refState.getNode());
            super.firePropertyChange("add_children", new Integer(i), state);
        }
    }

    @Override
    public void moveInlineFlowState(IInlineFlowState state, int i) {
    }

    @Override
    public void removeInlineFlowState(IInlineFlowState state) {
        if (this.inlineFlows.contains(state)) {
            this.inlineFlows.remove(state);
            this.getNode().removeChild((Node)state.getNode());
            super.fireStructureChange("remove_children", state);
        }
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (IState iState : this.getStates()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iState.accept(visitor, monitor);
            }
            for (IImport iImport : this.getImports()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iImport.accept(visitor, monitor);
            }
            for (IInlineFlowState iInlineFlowState : this.getInlineFlowStates()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iInlineFlowState.accept(visitor, monitor);
            }
            for (IAttribute iAttribute : this.getAttributes()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iAttribute.accept(visitor, monitor);
            }
            for (IInputAttribute iInputAttribute : this.getInputAttributes()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iInputAttribute.accept(visitor, monitor);
            }
            for (IOutputAttribute iOutputAttribute : this.getOutputAttributes()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iOutputAttribute.accept(visitor, monitor);
            }
            for (IVar iVar : this.getVars()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iVar.accept(visitor, monitor);
            }
            for (IExceptionHandler iExceptionHandler : this.getExceptionHandlers()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iExceptionHandler.accept(visitor, monitor);
            }
            if (monitor.isCanceled()) {
                return;
            }
            if (this.getInputMapper() != null) {
                this.getInputMapper().accept(visitor, monitor);
            }
            if (this.getOutputMapper() != null) {
                this.getInputMapper().accept(visitor, monitor);
            }
            if (this.getEntryActions() != null) {
                this.getEntryActions().accept(visitor, monitor);
            }
            if (this.getExitActions() != null) {
                this.getExitActions().accept(visitor, monitor);
            }
        }
    }

    public IModelElement[] getElementChildren() {
        HashSet<IWebflowModelElement> children = new HashSet<IWebflowModelElement>();
        children.addAll(this.getStates());
        children.addAll(this.getImports());
        children.addAll(this.getInlineFlowStates());
        children.addAll(this.getAttributes());
        children.addAll(this.getVars());
        children.addAll(this.getInputAttributes());
        children.addAll(this.getOutputAttributes());
        children.addAll(this.getExceptionHandlers());
        children.add(this.getInputMapper());
        return children.toArray(new IModelElement[children.size()]);
    }

    @Override
    public IGlobalTransitions getGlobalTransitions() {
        return this.globalTransition;
    }

    @Override
    public void setGlobalTransitions(IGlobalTransitions inputMapper) {
        if (this.globalTransition != null) {
            this.getNode().removeChild((Node)this.globalTransition.getNode());
        }
        this.globalTransition = inputMapper;
        if (inputMapper != null) {
            WebflowModelXmlUtils.insertNode((Node)inputMapper.getNode(), (Node)this.getNode());
        }
        super.fireStructureChange("add_children", inputMapper);
    }

    @Override
    public IModelElement getElementParent() {
        return this.webflowConfig;
    }

    @Override
    public String getAbstract() {
        return this.getAttribute("abstract");
    }

    @Override
    public void setAbstract(String abstrakt) {
        this.setAttribute("abstract", abstrakt);
    }

    @Override
    public List<IInputAttribute> getInputAttributes() {
        return this.inputAttributes;
    }

    @Override
    public void addInputAttribute(IInputAttribute action) {
        if (!this.inputAttributes.contains(action)) {
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.node);
            this.inputAttributes.add(action);
            super.firePropertyChange("add_children", new Integer(this.inputAttributes.indexOf(action)), action);
        }
    }

    @Override
    public void addInputAttribute(IInputAttribute action, int i) {
        if (!this.inputAttributes.contains(action)) {
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.node);
            this.inputAttributes.add(i, action);
            super.firePropertyChange("add_children", new Integer(this.inputAttributes.indexOf(action)), action);
        }
    }

    @Override
    public void removeAllInputAttribute() {
        for (IInputAttribute action : this.inputAttributes) {
            this.getNode().removeChild((Node)action.getNode());
        }
        this.inputAttributes = new ArrayList<IInputAttribute>();
    }

    @Override
    public void removeInputAttribute(IInputAttribute action) {
        if (this.inputAttributes.contains(action)) {
            this.inputAttributes.remove(action);
            this.getNode().removeChild((Node)action.getNode());
            super.fireStructureChange("remove_children", action);
        }
    }

    @Override
    public List<IOutputAttribute> getOutputAttributes() {
        return this.outputAttributes;
    }

    @Override
    public void addOutputAttribute(IOutputAttribute action) {
        if (!this.outputAttributes.contains(action)) {
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.node);
            this.outputAttributes.add(action);
            super.firePropertyChange("add_children", new Integer(this.outputAttributes.indexOf(action)), action);
        }
    }

    @Override
    public void addOutputAttribute(IOutputAttribute action, int i) {
        if (!this.outputAttributes.contains(action)) {
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.node);
            this.outputAttributes.add(i, action);
            super.firePropertyChange("add_children", new Integer(this.outputAttributes.indexOf(action)), action);
        }
    }

    @Override
    public void removeAllOutputAttribute() {
        for (IInputAttribute iInputAttribute : this.outputAttributes) {
            this.getNode().removeChild((Node)iInputAttribute.getNode());
        }
        this.outputAttributes = new ArrayList<IOutputAttribute>();
    }

    @Override
    public void removeOutputAttribute(IOutputAttribute action) {
        if (this.outputAttributes.contains(action)) {
            this.outputAttributes.remove(action);
            this.getNode().removeChild((Node)action.getNode());
            super.fireStructureChange("remove_children", action);
        }
    }

    @Override
    public void addPersistenceContext() {
        if (!this.hasPersitenceContext()) {
            Element startNode = this.getNode().getOwnerDocument().createElement("persistence-context");
            WebflowModelXmlUtils.insertNode(startNode, (Node)this.node);
        }
    }

    @Override
    public boolean hasPersitenceContext() {
        List<IDOMNode> nodes = this.getChildrenNodeByTagName("persistence-context");
        return nodes.size() > 0;
    }

    @Override
    public void removePersistenceContext() {
        if (this.hasPersitenceContext()) {
            List<IDOMNode> nodes = this.getChildrenNodeByTagName("persistence-context");
            for (IDOMNode node : nodes) {
                this.getNode().removeChild((Node)node);
            }
        }
    }
}

