/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractActionElement;
import org.springframework.ide.eclipse.webflow.core.internal.model.Action;
import org.springframework.ide.eclipse.webflow.core.internal.model.BeanAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.EvaluateAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.Set;
import org.springframework.ide.eclipse.webflow.core.internal.model.Transition;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IAttribute;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IStateTransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableFrom;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateTransition
extends Transition
implements IStateTransition,
ICloneableModelElement<IStateTransition> {
    private List<IActionElement> actions = null;

    public StateTransition() {
        super(null);
    }

    public StateTransition(IWebflowState webflowState) {
        super(webflowState);
    }

    @Override
    public void init(IDOMNode node, IWebflowModelElement parent) {
        super.init(node, parent);
        this.actions = new ArrayList<IActionElement>();
        NodeList children = node.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                AbstractActionElement action;
                IDOMNode child = (IDOMNode)children.item(i);
                if ("action".equals(child.getLocalName())) {
                    action = new Action();
                    action.init(child, this);
                    ((AbstractAction)action).setType(IActionElement.ACTION_TYPE.ACTION);
                    this.actions.add(action);
                } else if ("render".equals(child.getLocalName())) {
                    action = new Action();
                    action.init(child, this);
                    ((AbstractAction)action).setType(IActionElement.ACTION_TYPE.ACTION);
                    this.actions.add(action);
                } else if ("bean-action".equals(child.getLocalName())) {
                    action = new BeanAction();
                    ((BeanAction)action).init(child, this);
                    ((AbstractAction)action).setType(IActionElement.ACTION_TYPE.ACTION);
                    this.actions.add(action);
                } else if ("evaluate-action".equals(child.getLocalName())) {
                    action = new EvaluateAction();
                    ((EvaluateAction)action).init(child, this);
                    ((EvaluateAction)action).setType(IActionElement.ACTION_TYPE.ACTION);
                    this.actions.add(action);
                } else if ("evaluate".equals(child.getLocalName())) {
                    action = new EvaluateAction();
                    ((EvaluateAction)action).init(child, this);
                    ((EvaluateAction)action).setType(IActionElement.ACTION_TYPE.ACTION);
                    this.actions.add(action);
                } else if ("set".equals(child.getLocalName())) {
                    action = new Set();
                    action.init(child, this);
                    ((AbstractAction)action).setType(IActionElement.ACTION_TYPE.ACTION);
                    this.actions.add(action);
                }
                ++i;
            }
        }
    }

    @Override
    public void addAction(IActionElement action) {
        if (!this.actions.contains(action)) {
            this.actions.add(action);
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.getNode());
            super.firePropertyChange("add_children", new Integer(this.actions.indexOf(action)), action);
        }
    }

    @Override
    public void addAction(IActionElement action, int i) {
        if (!this.actions.contains(action)) {
            this.actions.add(i, action);
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.getNode());
            super.firePropertyChange("add_children", new Integer(i), action);
        }
    }

    @Override
    public List<IActionElement> getActions() {
        return this.actions;
    }

    @Override
    public String getOn() {
        return this.getAttribute("on");
    }

    @Override
    public void removeAction(IActionElement action) {
        if (this.actions.contains(action)) {
            this.actions.remove(action);
            this.getNode().removeChild((Node)action.getNode());
            super.fireStructureChange("remove_children", action);
        }
    }

    @Override
    public void setOn(String on) {
        this.setAttribute("on", on);
    }

    @Override
    public ITransitionableFrom getFromState() {
        return (ITransitionableFrom)this.parent;
    }

    @Override
    public void setFromState(ITransitionableFrom fromState) {
        Node parent = this.node.getParentNode();
        if (parent != null) {
            parent.removeChild((Node)this.node);
        }
        WebflowModelXmlUtils.insertNode((Node)this.getNode(), (Node)fromState.getNode());
        this.parent = fromState;
    }

    @Override
    public IWebflowModelElement getElementParent() {
        return this.parent;
    }

    @Override
    public void createNew(IWebflowModelElement parent, IWebflowState webflowState) {
        this.webflowState = webflowState;
        IDOMNode node = (IDOMNode)parent.getNode().getOwnerDocument().createElement("transition");
        this.init(node, parent);
    }

    @Override
    public IStateTransition cloneModelElement() {
        StateTransition state = new StateTransition(this.webflowState);
        state.init((IDOMNode)this.node.cloneNode(true), this.parent);
        return state;
    }

    @Override
    public void applyCloneValues(IStateTransition element) {
        if (element != null) {
            if (this.node.getParentNode() != null) {
                this.parent.getNode().replaceChild((Node)element.getNode(), (Node)this.node);
            }
            this.setOn(element.getOn());
            this.init(element.getNode(), this.parent);
            WebflowModelXmlUtils.removeTextChildren((Node)this.getNode());
            super.fireStructureChange("move_children", new Integer(0));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void initFromClone(IDOMNode cloneNode) {
        this.removeAll();
        ArrayList<IDOMNode> nodesToAdd = new ArrayList<IDOMNode>();
        IDOMNode newNode = (IDOMNode)this.parent.getNode().getOwnerDocument().createElement("transition");
        this.setAttribute(newNode, "on", this.getAttribute(cloneNode, "on"));
        this.setAttribute(newNode, "to", this.getAttribute(cloneNode, "to"));
        NodeList children = cloneNode.getChildNodes();
        if (children != null && children.getLength() > 0) {
            void var5_6;
            boolean bl = false;
            while (var5_6 < children.getLength()) {
                AbstractActionElement action;
                IDOMNode child = (IDOMNode)children.item((int)var5_6);
                nodesToAdd.add(child);
                if ("action".equals(child.getLocalName())) {
                    action = new Action();
                    action.init(child, this);
                    this.actions.add(action);
                } else if ("render".equals(child.getLocalName())) {
                    action = new Action();
                    action.init(child, this);
                    this.actions.add(action);
                } else if ("bean-action".equals(child.getLocalName())) {
                    action = new BeanAction();
                    ((BeanAction)action).init(child, this);
                    this.actions.add(action);
                } else if ("evaluate-action".equals(child.getLocalName())) {
                    action = new EvaluateAction();
                    ((EvaluateAction)action).init(child, this);
                    this.actions.add(action);
                } else if ("set".equals(child.getLocalName())) {
                    action = new Set();
                    action.init(child, this);
                    this.actions.add(action);
                }
                ++var5_6;
            }
        }
        for (Node node : nodesToAdd) {
            if (node.getParentNode() != null) {
                node.getParentNode().removeChild(node);
            }
            newNode.appendChild(node);
        }
        if (this.getNode().getParentNode() != null) {
            this.parent.getNode().replaceChild((Node)newNode, (Node)this.getNode());
        }
        WebflowModelXmlUtils.removeTextChildren((Node)newNode);
        this.node = newNode;
    }

    @Override
    public void removeAll() {
        for (IActionElement action : this.actions) {
            this.getNode().removeChild((Node)action.getNode());
        }
        this.actions = new ArrayList<IActionElement>();
    }

    @Override
    public String getOnException() {
        return this.getAttribute("on-exception");
    }

    @Override
    public void setOnException(String exception) {
        this.setAttribute("on-exception", exception);
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (IAttribute state : this.getAttributes()) {
                if (monitor.isCanceled()) {
                    return;
                }
                state.accept(visitor, monitor);
            }
            for (IActionElement action : this.getActions()) {
                if (monitor.isCanceled()) {
                    return;
                }
                action.accept(visitor, monitor);
            }
        }
    }

    @Override
    public void setToStateId(String id) {
        this.setAttribute("to", id);
    }

    public IModelElement[] getElementChildren() {
        ArrayList<IWebflowModelElement> children = new ArrayList<IWebflowModelElement>();
        children.addAll(this.getAttributes());
        children.addAll(this.getActions());
        return children.toArray(new IModelElement[children.size()]);
    }

    @Override
    public String getBind() {
        return this.getAttribute("bind");
    }

    @Override
    public void setBind(String bind) {
        this.setAttribute("bind", bind);
    }

    @Override
    public String getHistory() {
        return this.getAttribute("history");
    }

    @Override
    public void setHistory(String history) {
        this.setAttribute("history", history);
    }
}

