/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.webflow.core.internal.model.Transition;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IIf;
import org.springframework.ide.eclipse.webflow.core.model.IIfTransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableTo;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.w3c.dom.Node;

public class IfTransition
extends Transition
implements IIfTransition {
    private boolean isThen;

    public IfTransition(IWebflowState webflowState, boolean isThen) {
        super(webflowState);
        this.isThen = isThen;
    }

    public boolean isThen() {
        return this.isThen;
    }

    public void setThen(boolean isThen) {
        boolean oldValue = this.isThen;
        this.isThen = isThen;
        super.firePropertyChange("properties", new Boolean(oldValue), new Boolean(isThen));
    }

    public IIf getFromIf() {
        return (IIf)this.parent;
    }

    public void setFromIf(IIf fromIf) {
        Node parent = this.node.getParentNode();
        if (parent != null) {
            parent.removeChild((Node)this.node);
        }
        fromIf.getNode().appendChild((Node)this.node);
        this.parent = fromIf;
    }

    public String getToStateId() {
        if (this.isThen) {
            return this.getAttribute("then");
        }
        return this.getAttribute("else");
    }

    public void setToState(ITransitionableTo state) {
        Object newTargetState = null;
        if (state != null) {
            newTargetState = (ITransitionableTo)WebflowModelXmlUtils.getStateById(this.webflowState, state.getId());
        }
        if (newTargetState != null && !newTargetState.equals(newTargetState)) {
            if (this.targetState != null) {
                this.targetState.removeInputTransition(this);
            }
            if (this.isThen) {
                this.setAttribute(this.parent.getNode(), "then", state.getId());
            } else {
                this.setAttribute(this.parent.getNode(), "else", state.getId());
            }
            super.fireStructureChange("outputs", state);
            this.targetState = newTargetState;
            if (this.targetState != null) {
                this.targetState.addInputTransition(this);
            }
        } else {
            if (state != null) {
                if (this.isThen) {
                    this.setAttribute(this.parent.getNode(), "then", state.getId());
                } else {
                    this.setAttribute(this.parent.getNode(), "else", state.getId());
                }
            } else {
                this.targetState = newTargetState;
            }
            super.fireStructureChange("outputs", state);
        }
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        visitor.visit((IModelElement)this, monitor);
    }

    public void setToStateId(String id) {
        if (this.isThen) {
            this.setAttribute("then", id);
        } else {
            this.setAttribute("else", id);
        }
    }

    public IModelElement[] getElementChildren() {
        ArrayList children = new ArrayList();
        return children.toArray(new IModelElement[children.size()]);
    }
}

