/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.client.OperationResourceCollector;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class ResolveResourcesCommand
implements ISVNCommand {
    private final SVNWorkspaceRoot root;
    private final IResource[] resources;
    private final int resolution;
    private OperationResourceCollector operationResourceCollector = new OperationResourceCollector();

    public ResolveResourcesCommand(SVNWorkspaceRoot root, IResource[] resources, int resolution) {
        this.root = root;
        this.resources = resources;
        this.resolution = resolution;
    }

    public void run(IProgressMonitor monitor) throws SVNException {
        ISVNClientAdapter svnClient = this.root.getRepository().getSVNClient();
        try {
            try {
                svnClient.addNotifyListener((ISVNNotifyListener)this.operationResourceCollector);
                OperationManager.getInstance().beginOperation(svnClient);
                int i = 0;
                while (i < this.resources.length) {
                    svnClient.resolve(this.resources[i].getLocation().toFile(), this.resolution);
                    monitor.worked(100);
                    ++i;
                }
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        finally {
            Set<IResource> operationResources = this.operationResourceCollector.getOperationResources();
            OperationManager.getInstance().endOperation(true, operationResources);
            if (svnClient != null) {
                svnClient.removeNotifyListener((ISVNNotifyListener)this.operationResourceCollector);
                this.root.getRepository().returnSVNClient(svnClient);
            }
            monitor.done();
        }
    }
}

