/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.Preferences;
import org.tigris.subversion.subclipse.core.IMessageHandler;
import org.tigris.subversion.subclipse.core.IResourceStateChangeListener;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.ISVNRunnable;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNAdapterFactories;
import org.tigris.subversion.subclipse.core.SVNClientManager;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.client.IConsoleListener;
import org.tigris.subversion.subclipse.core.mapping.SVNActiveChangeSetCollector;
import org.tigris.subversion.subclipse.core.repo.SVNRepositories;
import org.tigris.subversion.subclipse.core.resources.ISVNFileModificationValidatorPrompt;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.RepositoryResourcesManager;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.resourcesListeners.FileModificationManager;
import org.tigris.subversion.subclipse.core.resourcesListeners.RevertResourceManager;
import org.tigris.subversion.subclipse.core.resourcesListeners.SyncFileChangeListener;
import org.tigris.subversion.subclipse.core.resourcesListeners.TeamPrivateListener;
import org.tigris.subversion.subclipse.core.status.StatusCacheManager;
import org.tigris.subversion.subclipse.core.sync.SVNWorkspaceSubscriber;
import org.tigris.subversion.subclipse.core.util.ISimpleDialogsHelper;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;

public class SVNProviderPlugin
extends Plugin {
    public static final String ID = "org.tigris.subversion.subclipse.core";
    public static final String PROVIDER_ID = "org.tigris.subversion.subclipse.core.svnnature";
    public static final String SVN_PROPERTY_TYPES_EXTENSION = "svnPropertyTypes";
    public static final String SVN_PROPERTY_GROUPS_EXTENSION = "svnPropertyGroups";
    private static final String NATURE_ID = "org.tigris.subversion.subclipse.core.svnnature";
    private static volatile SVNProviderPlugin instance;
    public static final String MESSAGE_HANDLERS = "org.tigris.subversion.subclipse.core.messageHandlers";
    private static IMessageHandler[] messageHandlers;
    private IConsoleListener consoleListener;
    private FileModificationManager fileModificationManager;
    private SyncFileChangeListener metaFileSyncListener;
    private TeamPrivateListener teamPrivateListener;
    private SVNRepositories repositories;
    private StatusCacheManager statusCacheManager;
    private RepositoryResourcesManager repositoryResourcesManager = new RepositoryResourcesManager();
    private SVNClientManager svnClientManager;
    private SVNAdapterFactories adapterFactories;
    private ISVNPromptUserPassword svnPromptUserPassword;
    private ISimpleDialogsHelper simpleDialogsHelper;
    private ISVNFileModificationValidatorPrompt svnFileModificationValidatorPrompt;
    private SVNActiveChangeSetCollector changeSetManager;
    private RevertResourceManager revertManager;
    private static boolean consoleLoggingEnabled;
    public static final String UPGRADE_NEEDED = "working copy needs to be upgraded";
    private static List<IResourceStateChangeListener> listeners;

    static {
        consoleLoggingEnabled = true;
        listeners = new ArrayList<IResourceStateChangeListener>();
    }

    public SVNProviderPlugin() {
        instance = this;
    }

    public static void log(int severity, String message, Throwable e) {
        SVNProviderPlugin.log((IStatus)new Status(severity, ID, 0, message, e));
    }

    public static void log(TeamException e) {
        SVNProviderPlugin.log(e.getStatus());
    }

    public static void log(IStatus status) {
        SVNProviderPlugin.getPlugin().getLog().log(status);
    }

    public static void handleMessage(String title, String message, int severity) {
        IMessageHandler[] iMessageHandlerArray = messageHandlers;
        int n = 0;
        int n2 = iMessageHandlerArray.length;
        while (n < n2) {
            IMessageHandler messageHandler = iMessageHandlerArray[n];
            messageHandler.handleMessage(title, message, severity);
            ++n;
        }
    }

    public static boolean handleQuestion(String title, String question) {
        return messageHandlers[0].handleQuestion(title, question);
    }

    public static SVNProviderPlugin getPlugin() {
        return instance;
    }

    public void start(BundleContext ctxt) throws Exception {
        super.start(ctxt);
        messageHandlers = SVNProviderPlugin.getMessageHandlers();
        this.adapterFactories = new SVNAdapterFactories();
        this.adapterFactories.startup(null);
        this.statusCacheManager = new StatusCacheManager();
        this.getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this.statusCacheManager);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.teamPrivateListener = new TeamPrivateListener();
        this.fileModificationManager = new FileModificationManager();
        this.getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this.fileModificationManager);
        this.metaFileSyncListener = new SyncFileChangeListener();
        this.revertManager = new RevertResourceManager();
        workspace.addResourceChangeListener((IResourceChangeListener)this.teamPrivateListener, 1);
        workspace.addResourceChangeListener((IResourceChangeListener)this.statusCacheManager, 8);
        workspace.addResourceChangeListener((IResourceChangeListener)this.metaFileSyncListener, 8);
        workspace.addResourceChangeListener((IResourceChangeListener)this.fileModificationManager, 1);
        workspace.addResourceChangeListener((IResourceChangeListener)this.revertManager, 8);
        this.teamPrivateListener.registerSaveParticipant();
        this.fileModificationManager.registerSaveParticipant();
        this.getChangeSetManager();
    }

    public void stop(BundleContext ctxt) throws Exception {
        super.stop(ctxt);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.statusCacheManager);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.metaFileSyncListener);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.fileModificationManager);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.teamPrivateListener);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.revertManager);
        if (this.repositories != null) {
            this.repositories.shutdown();
        }
        this.adapterFactories.shutdown(null);
        this.getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this.statusCacheManager);
        this.savePluginPreferences();
        workspace.removeSaveParticipant((Plugin)this);
        if (this.svnClientManager != null) {
            this.svnClientManager.shutdown(null);
        }
        this.getChangeSetManager().dispose();
    }

    public static IMessageHandler[] getMessageHandlers() throws Exception {
        if (messageHandlers == null) {
            ArrayList<IMessageHandler> messageHandlerList = new ArrayList<IMessageHandler>();
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] configurationElements = extensionRegistry.getConfigurationElementsFor(MESSAGE_HANDLERS);
            int i = 0;
            while (i < configurationElements.length) {
                IConfigurationElement configurationElement = configurationElements[i];
                IMessageHandler messageHandler = (IMessageHandler)configurationElement.createExecutableExtension("class");
                messageHandlerList.add(messageHandler);
                ++i;
            }
            messageHandlers = new IMessageHandler[messageHandlerList.size()];
            messageHandlerList.toArray(messageHandlers);
        }
        return messageHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addResourceStateChangeListener(IResourceStateChangeListener listener) {
        List<IResourceStateChangeListener> list = listeners;
        synchronized (list) {
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeResourceStateChangeListener(IResourceStateChangeListener listener) {
        List<IResourceStateChangeListener> list = listeners;
        synchronized (list) {
            listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void broadcastSyncInfoChanges(final IResource[] resources, final boolean initializeListeners) {
        IResourceStateChangeListener[] toNotify;
        List<IResourceStateChangeListener> list = listeners;
        synchronized (list) {
            toNotify = listeners.toArray(new IResourceStateChangeListener[listeners.size()]);
        }
        int i = 0;
        while (i < toNotify.length) {
            final IResourceStateChangeListener listener = toNotify[i];
            ISafeRunnable code = new ISafeRunnable(){

                public void run() throws Exception {
                    if (initializeListeners) {
                        listener.initialize();
                    }
                    listener.resourceSyncInfoChanged(resources);
                }

                public void handleException(Throwable e) {
                }
            };
            SafeRunner.run((ISafeRunnable)code);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void broadcastModificationStateChanges(final IResource[] resources) {
        IResourceStateChangeListener[] toNotify;
        List<IResourceStateChangeListener> list = listeners;
        synchronized (list) {
            toNotify = listeners.toArray(new IResourceStateChangeListener[listeners.size()]);
        }
        int i = 0;
        while (i < toNotify.length) {
            final IResourceStateChangeListener listener = toNotify[i];
            ISafeRunnable code = new ISafeRunnable(){

                public void run() throws Exception {
                    listener.resourceModified(resources);
                }

                public void handleException(Throwable e) {
                }
            };
            SafeRunner.run((ISafeRunnable)code);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void broadcastProjectConfigured(final IProject project) {
        IResourceStateChangeListener[] toNotify;
        List<IResourceStateChangeListener> list = listeners;
        synchronized (list) {
            toNotify = listeners.toArray(new IResourceStateChangeListener[listeners.size()]);
        }
        int i = 0;
        while (i < toNotify.length) {
            final IResourceStateChangeListener listener = toNotify[i];
            ISafeRunnable code = new ISafeRunnable(){

                public void run() throws Exception {
                    listener.projectConfigured(project);
                }

                public void handleException(Throwable e) {
                }
            };
            SafeRunner.run((ISafeRunnable)code);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void broadcastProjectDeconfigured(final IProject project) {
        IResourceStateChangeListener[] toNotify;
        List<IResourceStateChangeListener> list = listeners;
        synchronized (list) {
            toNotify = listeners.toArray(new IResourceStateChangeListener[listeners.size()]);
        }
        int i = 0;
        while (i < toNotify.length) {
            final IResourceStateChangeListener listener = toNotify[i];
            ISafeRunnable code = new ISafeRunnable(){

                public void run() throws Exception {
                    listener.projectDeconfigured(project);
                }

                public void handleException(Throwable e) {
                }
            };
            SafeRunner.run((ISafeRunnable)code);
            ++i;
        }
    }

    public ISVNRepositoryLocation getRepository(String location) throws SVNException {
        return this.getRepositories().getRepository(location);
    }

    public SVNRepositories getRepositories() {
        if (this.repositories == null) {
            this.repositories = new SVNRepositories();
            this.repositories.startup();
        }
        return this.repositories;
    }

    public StatusCacheManager getStatusCacheManager() {
        return this.statusCacheManager;
    }

    public SVNClientManager getSVNClientManager() {
        if (this.svnClientManager == null) {
            this.svnClientManager = new SVNClientManager();
            try {
                this.svnClientManager.startup(null);
            }
            catch (CoreException coreException) {}
        }
        return this.svnClientManager;
    }

    public ISVNClientAdapter getSVNClient() throws SVNException {
        return this.getSVNClientManager().getSVNClient();
    }

    public void setConsoleListener(IConsoleListener consoleListener) {
        this.consoleListener = consoleListener;
    }

    public IConsoleListener getConsoleListener() {
        if (consoleLoggingEnabled) {
            return this.consoleListener;
        }
        return null;
    }

    public static String getTypeId() {
        return "org.tigris.subversion.subclipse.core.svnnature";
    }

    public static void run(final ISVNRunnable job, IProgressMonitor monitor) throws SVNException {
        final SVNException[] error = new SVNException[1];
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    try {
                        monitor = Policy.monitorFor(monitor);
                        try {
                            job.run(monitor);
                        }
                        finally {
                            monitor.done();
                        }
                    }
                    catch (SVNException e) {
                        error[0] = e;
                    }
                }
            }, monitor);
        }
        catch (CoreException e) {
            throw SVNException.wrapException(e);
        }
        if (error[0] != null) {
            throw error[0];
        }
    }

    public static void run(final ISVNRunnable job, ISchedulingRule rule, IProgressMonitor monitor) throws SVNException {
        final SVNException[] error = new SVNException[1];
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    try {
                        monitor = Policy.monitorFor(monitor);
                        try {
                            job.run(monitor);
                        }
                        finally {
                            monitor.done();
                        }
                    }
                    catch (SVNException e) {
                        error[0] = e;
                    }
                }
            }, rule, 1, monitor);
        }
        catch (CoreException e) {
            throw SVNException.wrapException(e);
        }
        if (error[0] != null) {
            throw error[0];
        }
    }

    public RepositoryResourcesManager getRepositoryResourcesManager() {
        return this.repositoryResourcesManager;
    }

    public ISVNPromptUserPassword getSvnPromptUserPassword() {
        return this.svnPromptUserPassword;
    }

    public void setSvnPromptUserPassword(ISVNPromptUserPassword svnPromptUserPassword) {
        this.svnPromptUserPassword = svnPromptUserPassword;
    }

    public ISimpleDialogsHelper getSimpleDialogsHelper() {
        return this.simpleDialogsHelper;
    }

    public void setSimpleDialogsHelper(ISimpleDialogsHelper simpleDialogsHelper) {
        this.simpleDialogsHelper = simpleDialogsHelper;
    }

    public ISVNFileModificationValidatorPrompt getSvnFileModificationValidatorPrompt() {
        return this.svnFileModificationValidatorPrompt;
    }

    public void setSvnFileModificationValidatorPrompt(ISVNFileModificationValidatorPrompt svnFileModificationValidatorPrompt) {
        this.svnFileModificationValidatorPrompt = svnFileModificationValidatorPrompt;
    }

    public String getAdminDirectoryName() {
        return this.getSVNClientManager().getSvnAdminDirectory();
    }

    public boolean isManagedBySubversion(IContainer container) {
        if (container instanceof IProject && RepositoryProvider.getProvider((IProject)((IProject)container), (String)SVNProviderPlugin.getTypeId()) != null) {
            return true;
        }
        return this.isManagedBySubversion(container.getLocation());
    }

    public boolean isManagedBySubversion(IPath folder) {
        block4: {
            File svnDir = folder.append(this.getAdminDirectoryName()).toFile();
            if (svnDir == null || !svnDir.exists() || !svnDir.isDirectory()) {
                return false;
            }
            try {
                LocalResourceStatus status = SVNWorkspaceRoot.peekResourceStatusFor(folder);
                if (status.hasRemote()) {
                    return true;
                }
            }
            catch (SVNException e) {
                if (e.getMessage() == null || !e.getMessage().contains(UPGRADE_NEEDED)) break block4;
                return true;
            }
        }
        return false;
    }

    public Preferences getInstancePreferences() {
        return new InstanceScope().getNode(this.getBundle().getSymbolicName());
    }

    public boolean isAdminDirectory(String name) {
        return ".svn".equals(name) || this.getAdminDirectoryName().equals(name);
    }

    public synchronized ActiveChangeSetManager getChangeSetManager() {
        if (this.changeSetManager == null) {
            this.changeSetManager = new SVNActiveChangeSetCollector(SVNWorkspaceSubscriber.getInstance());
        }
        return this.changeSetManager;
    }

    public static void enableConsoleLogging() {
        consoleLoggingEnabled = true;
    }

    public static void disableConsoleLogging() {
        consoleLoggingEnabled = false;
    }
}

