/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.ide.eclipse.beans.ui.editor.outline.DelegatingLabelProvider;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanReferenceSearchRequestor {
    public static final String LABEL_SEPARATOR = " -------------------------------------------- ";
    public static final int TYPE_MATCHING_RELEVANCE = 20;
    public static final int RELEVANCE = 10;
    protected Set<String> beans;
    protected IContentAssistProposalRecorder recorder;
    protected List<String> requiredTypes = null;
    private boolean insertedMatchingType = false;
    private boolean matchingTypeFound = false;

    public BeanReferenceSearchRequestor(IContentAssistProposalRecorder recorder) {
        this(recorder, new ArrayList<String>());
    }

    public BeanReferenceSearchRequestor(IContentAssistProposalRecorder recorder, List<String> requiredTypes) {
        this.recorder = recorder;
        this.beans = new HashSet<String>();
        this.requiredTypes = requiredTypes;
    }

    public void acceptSearchMatch(IBean bean, IFile file, String prefix) {
        if (bean.getElementName() != null && bean.getElementName().toLowerCase().startsWith(prefix.toLowerCase())) {
            String beanName;
            String replaceText = beanName = bean.getElementName();
            String fileName = bean.getElementResource().getProjectRelativePath().toString();
            String key = String.valueOf(beanName) + fileName;
            if (!this.beans.contains(key)) {
                StringBuffer buf = new StringBuffer();
                buf.append(beanName);
                if (bean.getClassName() != null) {
                    String className = bean.getClassName();
                    buf.append(" [");
                    buf.append(Signature.getSimpleName((String)className));
                    buf.append("]");
                }
                if (bean.getParentName() != null) {
                    buf.append(" <");
                    buf.append(bean.getParentName());
                    buf.append(">");
                }
                buf.append(" - ");
                buf.append(fileName);
                String displayText = buf.toString();
                Image image = null;
                if (Display.getCurrent() != null) {
                    image = BeansUIPlugin.getLabelProvider().getImage((Object)bean);
                }
                boolean matchesType = false;
                if (this.requiredTypes.size() > 0) {
                    String className = BeansModelUtils.getBeanClass((IBean)bean, null);
                    IType type = JdtUtils.getJavaType((IProject)file.getProject(), (String)className);
                    List hierachyTypes = JdtUtils.getFlatListOfClassAndInterfaceNames((IType)type, (IType)type);
                    for (String cn : hierachyTypes) {
                        if (!this.requiredTypes.contains(cn)) continue;
                        matchesType = true;
                        break;
                    }
                }
                if (!this.insertedMatchingType && this.matchingTypeFound && !matchesType) {
                    this.recorder.recordProposal(BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.content_assist_separator_obj.gif"), 19, LABEL_SEPARATOR, "");
                    this.insertedMatchingType = true;
                }
                if (matchesType) {
                    this.recorder.recordProposal(image, 20, displayText, replaceText, null);
                    this.matchingTypeFound = true;
                } else {
                    this.recorder.recordProposal(image, 10, displayText, replaceText, bean);
                }
                this.beans.add(key);
            }
        }
    }

    public void acceptSearchMatch(String beanId, Node beanNode, IFile file, String prefix) {
        NamedNodeMap attributes = beanNode.getAttributes();
        if (beanId.toLowerCase().startsWith(prefix.toLowerCase()) && beanNode.getParentNode() != null) {
            String beanName;
            String replaceText = beanName = beanId;
            String fileName = file.getProjectRelativePath().toString();
            String key = String.valueOf(beanName) + fileName;
            if (!this.beans.contains(key)) {
                StringBuffer buf = new StringBuffer();
                buf.append(beanName);
                if (attributes.getNamedItem("class") != null) {
                    String className = attributes.getNamedItem("class").getNodeValue();
                    buf.append(" [");
                    buf.append(Signature.getSimpleName((String)className));
                    buf.append("]");
                }
                if (attributes.getNamedItem("parent") != null) {
                    String parentName = attributes.getNamedItem("parent").getNodeValue();
                    buf.append(" <");
                    buf.append(parentName);
                    buf.append(">");
                }
                buf.append(" - ");
                buf.append(fileName);
                String displayText = buf.toString();
                Image image = null;
                if (Display.getCurrent() != null) {
                    image = new DelegatingLabelProvider().getImage(beanNode);
                }
                String className = BeansEditorUtils.getClassNameForBean(beanNode);
                boolean matchesType = false;
                if (this.requiredTypes.size() > 0) {
                    IType type = JdtUtils.getJavaType((IProject)file.getProject(), (String)className);
                    List hierachyTypes = JdtUtils.getFlatListOfClassAndInterfaceNames((IType)type, (IType)type);
                    for (String cn : hierachyTypes) {
                        if (!this.requiredTypes.contains(cn)) continue;
                        matchesType = true;
                        break;
                    }
                }
                if (!this.insertedMatchingType && this.matchingTypeFound && !matchesType) {
                    this.recorder.recordProposal(BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.content_assist_separator_obj.gif"), 19, LABEL_SEPARATOR, "");
                    this.insertedMatchingType = true;
                }
                if (matchesType) {
                    this.recorder.recordProposal(image, 20, displayText, replaceText, beanNode);
                    this.matchingTypeFound = true;
                } else {
                    this.recorder.recordProposal(image, 10, displayText, replaceText, beanNode);
                }
                this.beans.add(key);
            }
        }
    }
}

