/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.outline;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.ui.views.contentoutline.XMLContentOutlineConfiguration;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.INamespaceDefinition;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.beans.ui.namespaces.NamespaceUtils;
import org.w3c.dom.Node;

public class DelegatingLabelProvider
extends LabelProvider {
    private static XMLContentOutlineConfiguration contentOutlineConfiguration = new XMLContentOutlineConfiguration();
    private ILabelProvider xmlProvider;
    private boolean isContentAssist = false;

    public DelegatingLabelProvider(ILabelProvider xmlProvider) {
        this.xmlProvider = xmlProvider;
    }

    public DelegatingLabelProvider() {
        this.isContentAssist = true;
        this.xmlProvider = contentOutlineConfiguration.getLabelProvider(null);
    }

    public Image getImage(Object object) {
        ILabelProvider[] labelProviders;
        if (!BeansEditorUtils.isSpringStyleOutline() && !this.isContentAssist) {
            return this.xmlProvider.getImage(object);
        }
        Node node = (Node)object;
        String namespace = node.getNamespaceURI();
        ILabelProvider[] iLabelProviderArray = labelProviders = org.springframework.ide.eclipse.beans.ui.editor.namespaces.NamespaceUtils.getLabelProvider(namespace);
        int n = labelProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelProvider labelProvider = iLabelProviderArray[n2];
            Image image = labelProvider.getImage(object);
            if (image != null) {
                return image;
            }
            ++n2;
        }
        INamespaceDefinition namespaceDefinition = BeansCorePlugin.getNamespaceDefinitionResolver(null).resolveNamespaceDefinition(namespace);
        if (namespaceDefinition != null) {
            return NamespaceUtils.getImage((INamespaceDefinition)namespaceDefinition);
        }
        return this.xmlProvider.getImage(object);
    }

    public String getText(Object object) {
        ILabelProvider[] labelProviders;
        if (!BeansEditorUtils.isSpringStyleOutline() && !this.isContentAssist) {
            return this.xmlProvider.getText(object);
        }
        Node node = (Node)object;
        String namespace = node.getNamespaceURI();
        ILabelProvider[] iLabelProviderArray = labelProviders = org.springframework.ide.eclipse.beans.ui.editor.namespaces.NamespaceUtils.getLabelProvider(namespace);
        int n = labelProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelProvider labelProvider = iLabelProviderArray[n2];
            String text = labelProvider.getText(object);
            if (text != null && !"".equals(text.trim())) {
                return text;
            }
            ++n2;
        }
        return this.xmlProvider.getText(object);
    }
}

