/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.hyperlink.tool;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.namespaces.ToolAnnotationUtils;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.AbstractAnnotationBasedHyperlinkDetector;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.ExternalBeanHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.HyperlinkUtils;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.JavaElementHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.NodeElementHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class ToolAnnotationBasedHyperlinkDetector
extends AbstractAnnotationBasedHyperlinkDetector {
    private static final String REF_ATTRIBUTE = "ref";

    public IHyperlink createHyperlink(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor, Node annotation) {
        IType type;
        IHyperlink[] detectedHyperlinks;
        IFile file = BeansEditorUtils.getFile(document);
        ToolAnnotationUtils.ToolAnnotationData annotationData = ToolAnnotationUtils.getToolAnnotationData((Node)annotation);
        if (REF_ATTRIBUTE.equals(annotationData.getKind())) {
            Node bean = BeansEditorUtils.getFirstReferenceableNodeById(node.getOwnerDocument(), target, file);
            if (bean != null) {
                IRegion region = this.getHyperlinkRegion(bean);
                return new NodeElementHyperlink(hyperlinkRegion, region, textViewer);
            }
            for (IBean modelBean : BeansEditorUtils.getBeansFromConfigSets(file)) {
                if (!modelBean.getElementName().equals(target)) continue;
                return new ExternalBeanHyperlink((ISourceModelElement)modelBean, hyperlinkRegion);
            }
        } else if (Class.class.getName().equals(annotationData.getExpectedType()) && ((detectedHyperlinks = HyperlinkUtils.getXmlJavaHyperlinks(textViewer, hyperlinkRegion)) == null || detectedHyperlinks.length == 0) && file != null && file.exists() && (type = JdtUtils.getJavaType((IProject)file.getProject(), (String)target)) != null) {
            return new JavaElementHyperlink(hyperlinkRegion, (IJavaElement)type);
        }
        if (annotationData.getExpectedMethodType() != null) {
            String className = this.evaluateXPathExpression(annotationData.getExpectedMethodType(), node);
            return this.createMethodHyperlink(target, hyperlinkRegion, file, className);
        }
        if (annotationData.getExpectedMethodRef() != null) {
            String typeName = this.evaluateXPathExpression(annotationData.getExpectedMethodRef(), node);
            String className = BeansEditorUtils.getClassNameForBean(file, node.getOwnerDocument(), typeName);
            return this.createMethodHyperlink(target, hyperlinkRegion, file, className);
        }
        return null;
    }

    private IHyperlink createMethodHyperlink(String target, IRegion hyperlinkRegion, IFile file, String className) {
        if (file != null && file.exists()) {
            IType type = JdtUtils.getJavaType((IProject)file.getProject(), (String)className);
            try {
                IMethod method = Introspector.findMethod((IType)type, (String)target, (int)-1, (Introspector.Public)Introspector.Public.DONT_CARE, (Introspector.Static)Introspector.Static.DONT_CARE);
                if (method != null) {
                    return new JavaElementHyperlink(hyperlinkRegion, (IJavaElement)method);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    public boolean isLinkableAttr(Attr attr, Node annotation) {
        if ("annotation".equals(annotation.getLocalName()) && "http://www.springframework.org/schema/tool".equals(annotation.getNamespaceURI())) {
            ToolAnnotationUtils.ToolAnnotationData annotationData = ToolAnnotationUtils.getToolAnnotationData((Node)annotation);
            return annotationData != null && (REF_ATTRIBUTE.equals(annotationData.getKind()) || Class.class.getName().equals(annotationData.getExpectedType()) || annotationData.getExpectedMethodRef() != null || annotationData.getExpectedMethodType() != null);
        }
        return false;
    }

    protected String evaluateXPathExpression(String xpath, Node node) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath path = factory.newXPath();
        try {
            return path.evaluate(xpath, node);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }
}

