/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.hyperlink.aop;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.HyperlinkUtils;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.IHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.NodeElementHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PointcutReferenceHyperlinkCalculator
implements IHyperlinkCalculator {
    public IHyperlink createHyperlink(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
        IHyperlink hyperlink = this.searchPointcutElements(target, parentNode, textViewer, hyperlinkRegion);
        if (hyperlink == null && parentNode.getParentNode() != null) {
            hyperlink = this.searchPointcutElements(target, parentNode.getParentNode(), textViewer, hyperlinkRegion);
        }
        return hyperlink;
    }

    private IHyperlink searchPointcutElements(String name, Node node, ITextViewer textViewer, IRegion hyperlinkRegion) {
        NodeList beanNodes = node.getChildNodes();
        int i = 0;
        while (i < beanNodes.getLength()) {
            Node beanNode = beanNodes.item(i);
            if ("pointcut".equals(beanNode.getLocalName()) && name.equals(BeansEditorUtils.getAttribute(beanNode, "id"))) {
                IRegion region = HyperlinkUtils.getHyperlinkRegion(beanNode);
                return new NodeElementHyperlink(hyperlinkRegion, region, textViewer);
            }
            ++i;
        }
        return null;
    }
}

