/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.w3c.dom.Node;

public class NodeElementHyperlink
implements IHyperlink {
    private final IRegion region;
    private final IRegion targetRegion;
    private final ITextViewer viewer;
    private final IFile file;
    private final Node bean;

    public NodeElementHyperlink(Node bean, IFile file, IRegion region, IRegion targetRegion, ITextViewer viewer) {
        this.bean = bean;
        this.file = file;
        this.region = region;
        this.targetRegion = targetRegion;
        this.viewer = viewer;
    }

    public NodeElementHyperlink(IRegion region, IRegion targetRegion, ITextViewer viewer) {
        this(null, null, region, targetRegion, viewer);
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        if (this.bean != null && this.file != null) {
            try {
                Node profileNode;
                StringBuilder str = new StringBuilder();
                str.append("Navigate to ");
                str.append(this.viewer.getDocument().get(this.region.getOffset(), this.region.getLength()));
                Node parentNode = this.bean.getParentNode();
                if (parentNode != null && (profileNode = parentNode.getAttributes().getNamedItem("profile")) != null) {
                    str.append(" in profile \"");
                    str.append(profileNode.getNodeValue());
                    str.append("\"");
                }
                str.append(" - ");
                str.append(this.file.getName());
                return str.toString();
            }
            catch (BadLocationException badLocationException) {}
        }
        return "Navigate";
    }

    public void open() {
        this.viewer.setSelectedRange(this.targetRegion.getOffset(), 0);
        this.viewer.revealRange(this.targetRegion.getOffset(), this.targetRegion.getLength());
    }
}

