/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.hyperlink;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.core.io.Resource;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.DefaultBeanDefinitionRegistry;
import org.springframework.ide.eclipse.beans.core.internal.model.namespaces.DelegatingNamespaceHandlerResolver;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.namespaces.NamespaceUtils;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.AbstractHyperlinkDetector;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.IHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.IMultiHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.JavaElementHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NamespaceHyperlinkDetectorSupport
extends AbstractHyperlinkDetector {
    private static final Method FIND_PARSER_FOR_ELEMENT_METHOD;
    private Map<String, IHyperlinkCalculator> calculators = new HashMap<String, IHyperlinkCalculator>();

    static {
        Method method = null;
        try {
            method = NamespaceHandlerSupport.class.getDeclaredMethod("findParserForElement", Element.class, ParserContext.class);
            method.setAccessible(true);
        }
        catch (Exception exception) {}
        FIND_PARSER_FOR_ELEMENT_METHOD = method;
    }

    public IHyperlink createHyperlink(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
        IHyperlinkCalculator calculator;
        String parentNodeName = null;
        String parentNamespaceUri = null;
        if (parentNode != null) {
            parentNodeName = parentNode.getLocalName();
            parentNamespaceUri = parentNode.getNamespaceURI();
        }
        if ((calculator = this.locateHyperlinkCalculator(parentNamespaceUri, parentNodeName, node.getLocalName(), name)) != null) {
            return calculator.createHyperlink(name, target, node, parentNode, document, textViewer, hyperlinkRegion, cursor);
        }
        return null;
    }

    public IHyperlink[] createHyperlinks(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
        IHyperlinkCalculator calculator;
        String parentNodeName = null;
        String parentNamespaceUri = null;
        if (parentNode != null) {
            parentNodeName = parentNode.getLocalName();
            parentNamespaceUri = parentNode.getNamespaceURI();
        }
        if ((calculator = this.locateHyperlinkCalculator(parentNamespaceUri, parentNodeName, node.getLocalName(), name)) instanceof IMultiHyperlinkCalculator) {
            return ((IMultiHyperlinkCalculator)calculator).createHyperlinks(name, target, node, parentNode, document, textViewer, hyperlinkRegion, cursor);
        }
        if (calculator != null) {
            return new IHyperlink[]{calculator.createHyperlink(name, target, node, parentNode, document, textViewer, hyperlinkRegion, cursor)};
        }
        return null;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IHyperlink[] hyperlinks = super.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks);
        if (hyperlinks == null) {
            hyperlinks = new IHyperlink[]{};
        }
        IDocument document = textViewer.getDocument();
        Node currentNode = BeansEditorUtils.getNodeByOffset(document, region.getOffset());
        if ((canShowMultipleHyperlinks || hyperlinks.length == 0) && BeansEditorUtils.isElementAtOffset(currentNode, region.getOffset()) && currentNode instanceof Element) {
            hyperlinks = this.createBeanDefinitionParserHyperlink(hyperlinks, document, currentNode);
        }
        return hyperlinks;
    }

    public void init() {
    }

    public boolean isLinkableAttr(Attr attr) {
        Node parentNode = attr.getOwnerElement().getParentNode();
        String parentNodeName = null;
        String parentNamespaceUri = null;
        if (parentNode != null) {
            parentNodeName = parentNode.getLocalName();
            parentNamespaceUri = parentNode.getNamespaceURI();
        }
        return this.locateHyperlinkCalculator(parentNamespaceUri, parentNodeName, attr.getOwnerElement().getLocalName(), attr.getLocalName()) != null;
    }

    private IHyperlink[] createBeanDefinitionParserHyperlink(IHyperlink[] hyperlinks, IDocument document, Node currentNode) {
        String namespaceUri = currentNode.getNamespaceURI();
        IFile file = BeansEditorUtils.getFile(document);
        IBeansConfig config = BeansCorePlugin.getModel().getConfig(file, true);
        if (config != null && namespaceUri != null && !namespaceUri.equals("http://www.springframework.org/schema/beans")) {
            IType type;
            XmlReaderContext readerContext;
            Object parser;
            DelegatingNamespaceHandlerResolver resolver;
            NamespaceHandler handler;
            ClassLoader cl = BeansCorePlugin.getClassLoader();
            if (NamespaceUtils.useNamespacesFromClasspath((IProject)file.getProject())) {
                cl = JdtUtils.getClassLoader((IProject)file.getProject(), (ClassLoader)cl);
            }
            if ((handler = (resolver = new DelegatingNamespaceHandlerResolver(cl, config)).resolve(namespaceUri)) instanceof NamespaceHandlerSupport && (parser = ReflectionUtils.invokeMethod((Method)FIND_PARSER_FOR_ELEMENT_METHOD, (Object)handler, (Object[])new Object[]{(Element)currentNode, new ParserContext(readerContext = new XmlReaderContext((Resource)config.getAdapter(Resource.class), (ProblemReporter)new NoOpProblemReporter(), null, null, new XmlBeanDefinitionReader((BeanDefinitionRegistry)new DefaultBeanDefinitionRegistry()), (NamespaceHandlerResolver)resolver), new BeanDefinitionParserDelegate(readerContext))})) != null && (type = JdtUtils.getJavaType((IProject)file.getProject(), (String)parser.getClass().getName())) != null) {
                ArrayList<IHyperlink> links = new ArrayList<IHyperlink>(Arrays.asList(hyperlinks));
                links.add(new JavaElementHyperlink((IRegion)new Region(((IndexedRegion)currentNode).getStartOffset() + 1, currentNode.getNodeName().length()), (IJavaElement)type));
                hyperlinks = links.toArray(new IHyperlink[links.size()]);
            }
        }
        return hyperlinks;
    }

    private IHyperlinkCalculator locateHyperlinkCalculator(String parentNamespaceUri, String parentNodeName, String nodeName, String attributeName) {
        String key = this.createRegisteredName(parentNamespaceUri, parentNodeName, nodeName, attributeName);
        if (this.calculators.containsKey(key)) {
            return this.calculators.get(key);
        }
        key = this.createRegisteredName(null, null, nodeName, attributeName);
        if (this.calculators.containsKey(key)) {
            return this.calculators.get(key);
        }
        key = this.createRegisteredName(null, null, null, attributeName);
        if (this.calculators.containsKey(key)) {
            return this.calculators.get(key);
        }
        return null;
    }

    protected String createRegisteredName(String parentNamespaceUri, String parentNodeName, String nodeName, String attributeName) {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.hasText((String)parentNamespaceUri)) {
            builder.append("/parentNamespaceUri=");
            builder.append(parentNamespaceUri);
        } else {
            builder.append("/parentNamespaceUri=");
            builder.append("*");
        }
        if (StringUtils.hasText((String)parentNodeName)) {
            builder.append("/parentNodeName=");
            builder.append(parentNodeName);
        } else {
            builder.append("/parentNodeName=");
            builder.append("*");
        }
        if (StringUtils.hasText((String)nodeName)) {
            builder.append("/nodeName=");
            builder.append(nodeName);
        } else {
            builder.append("/nodeName=");
            builder.append("*");
        }
        if (StringUtils.hasText((String)attributeName)) {
            builder.append("/attribute=");
            builder.append(attributeName);
        }
        return builder.toString();
    }

    protected void registerHyperlinkCalculator(String attributeName, IHyperlinkCalculator calculator) {
        this.registerHyperlinkCalculator(null, attributeName, calculator);
    }

    protected void registerHyperlinkCalculator(String nodeName, String attributeName, IHyperlinkCalculator calculator) {
        this.registerHyperlinkCalculator(null, null, nodeName, attributeName, calculator);
    }

    protected void registerHyperlinkCalculator(String parentNamespaceUri, String parentNodeName, String nodeName, String attributeName, IHyperlinkCalculator calculator) {
        this.calculators.put(this.createRegisteredName(parentNamespaceUri, parentNodeName, nodeName, attributeName), calculator);
    }

    private static final class NoOpProblemReporter
    implements ProblemReporter {
        private NoOpProblemReporter() {
        }

        public void fatal(Problem problem) {
        }

        public void error(Problem problem) {
        }

        public void warning(Problem problem) {
        }
    }
}

