/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.hyperlink;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.core.StringUtils;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Node;

public class HyperlinkUtils {
    public static IRegion getHyperlinkRegion(Node node) {
        if (node != null) {
            switch (node.getNodeType()) {
                case 3: 
                case 10: {
                    IDOMNode docNode = (IDOMNode)node;
                    return new Region(docNode.getStartOffset(), docNode.getEndOffset() - docNode.getStartOffset());
                }
                case 1: {
                    IDOMElement element = (IDOMElement)node;
                    int endOffset = element.hasEndTag() && element.isClosed() ? element.getStartEndOffset() : element.getEndOffset();
                    return new Region(element.getStartOffset(), endOffset - element.getStartOffset());
                }
                case 2: {
                    IDOMAttr att = (IDOMAttr)node;
                    int regOffset = att.getValueRegionStartOffset();
                    int regLength = att.getValueRegionText().length();
                    String attValue = att.getValueRegionText();
                    if (StringUtils.isQuoted((String)attValue)) {
                        ++regOffset;
                        regLength -= 2;
                    }
                    return new Region(regOffset, regLength);
                }
            }
        }
        return null;
    }

    public static IHyperlink[] getXmlJavaHyperlinks(ITextViewer textViewer, IRegion hyperlinkRegion) {
        try {
            Class<?> clazz = Class.forName("org.eclipse.jst.jsp.ui.internal.hyperlink.XMLJavaHyperlinkDetector", false, ClassUtils.getDefaultClassLoader());
            Object target = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method method = clazz.getDeclaredMethod("detectHyperlinks", ITextViewer.class, IRegion.class, Boolean.TYPE);
            return (IHyperlink[])method.invoke(target, textViewer, hyperlinkRegion, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InstantiationException instantiationException) {}
        return null;
    }
}

