/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist.jms;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.MethodContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.FlagsMethodFilter;
import org.springframework.ide.eclipse.core.java.IMethodFilter;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.java.OrMethodFilter;

public class ListenerMethodContentAssistCalculator
extends MethodContentAssistCalculator
implements IContentAssistCalculator {
    private static IMethodFilter FILTER;

    static {
        OrMethodFilter filter = new OrMethodFilter();
        filter.addMethodFilter((IMethodFilter)new FlagsMethodFilter(20484));
        filter.addMethodFilter((IMethodFilter)new FlagsMethodFilter(20496));
        FILTER = filter;
    }

    public ListenerMethodContentAssistCalculator() {
        super(FILTER);
    }

    protected IType calculateType(IContentAssistContext context) {
        String ref;
        if (BeansEditorUtils.hasAttribute(context.getNode(), "ref") && (ref = BeansEditorUtils.getAttribute(context.getNode(), "ref")) != null) {
            IFile file = context.getFile();
            String className = BeansEditorUtils.getClassNameForBean(file, context.getDocument(), ref);
            if (file != null && file.exists()) {
                return JdtUtils.getJavaType((IProject)file.getProject(), (String)className);
            }
        }
        return null;
    }
}

