/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor;

import java.util.ArrayList;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.DelegatingContentAssistProcessor;
import org.springframework.ide.eclipse.beans.ui.editor.hover.BeansTextHoverProcessor;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.DelegatingHyperlinkDetector;

public class BeansStructuredTextViewerConfiguration
extends StructuredTextViewerConfigurationXML {
    public IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        IContentAssistProcessor[] processors = partitionType == "org.eclipse.wst.sse.ST_DEFAULT" || partitionType == "org.eclipse.wst.xml.XML_DEFAULT" ? new IContentAssistProcessor[]{new DelegatingContentAssistProcessor()} : super.getContentAssistProcessors(sourceViewer, partitionType);
        return processors;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        IHyperlinkDetector[] superDetectors;
        if (sourceViewer == null || !this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        ArrayList<IHyperlinkDetector> allDetectors = new ArrayList<IHyperlinkDetector>();
        allDetectors.add(new DelegatingHyperlinkDetector());
        IHyperlinkDetector[] iHyperlinkDetectorArray = superDetectors = super.getHyperlinkDetectors(sourceViewer);
        int n = superDetectors.length;
        int n2 = 0;
        while (n2 < n) {
            IHyperlinkDetector detector = iHyperlinkDetectorArray[n2];
            if (!allDetectors.contains(detector)) {
                allDetectors.add(detector);
            }
            ++n2;
        }
        return allDetectors.toArray(new IHyperlinkDetector[0]);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        if (contentType == "org.eclipse.wst.sse.ST_DEFAULT" || contentType == "org.eclipse.wst.xml.XML_DEFAULT") {
            return new BeansTextHoverProcessor();
        }
        return super.getTextHover(sourceViewer, contentType, stateMask);
    }
}

