/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.part;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.core.runtime.ForgeRuntimeState;
import org.jboss.tools.forge.ui.internal.console.ForgeConsole;
import org.jboss.tools.forge.ui.internal.console.ForgeConsoleManager;

public class SelectionSynchronizer
implements ISelectionListener {
    private ForgeRuntime runtime;
    private IEditorPart selectedPart;
    private IPartListener partListener = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            if (!(part instanceof IEditorPart) || part == SelectionSynchronizer.this.selectedPart) {
                return;
            }
            SelectionSynchronizer.this.selectedPart = (IEditorPart)part;
            IEditorInput editorInput = SelectionSynchronizer.this.selectedPart.getEditorInput();
            if (!(editorInput instanceof IFileEditorInput)) {
                return;
            }
            IFile file = ((IFileEditorInput)editorInput).getFile();
            if (file == null) {
                return;
            }
            String path = file.getLocation().toOSString();
            if (ForgeRuntimeState.RUNNING.equals((Object)SelectionSynchronizer.this.getRuntime().getState())) {
                ForgeConsole console = ForgeConsoleManager.INSTANCE.getConsole(SelectionSynchronizer.this.getRuntime());
                console.goToPath(path);
            }
        }
    };

    public SelectionSynchronizer(ForgeRuntime runtime) {
        this.runtime = runtime;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.getPartService().addPartListener(this.partListener);
        } else {
            this.getPartService().removePartListener(this.partListener);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(part instanceof IEditorPart) || part == this.selectedPart) {
            return;
        }
        this.selectedPart = (IEditorPart)part;
        if (this.getPartService().getActivePart() == part) {
            return;
        }
        IEditorInput editorInput = this.selectedPart.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            return;
        }
        IFile file = ((IFileEditorInput)editorInput).getFile();
        if (file == null) {
            return;
        }
        String path = file.getLocation().toOSString();
        if (ForgeRuntimeState.RUNNING.equals((Object)this.getRuntime().getState())) {
            ForgeConsole console = ForgeConsoleManager.INSTANCE.getConsole(this.getRuntime());
            console.goToPath(path);
        }
    }

    private IPartService getPartService() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return activeWorkbenchWindow.getPartService();
    }

    private ForgeRuntime getRuntime() {
        return this.runtime;
    }
}

