/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.control;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.tools.forge.core.furnace.FurnaceService;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;
import org.jboss.tools.forge.ui.internal.ext.control.ControlBuilder;
import org.jboss.tools.forge.ui.internal.ext.wizards.ForgeWizardPage;

public class TextAreaBoxControlBuilder
extends ControlBuilder<Text> {
    @Override
    public Text build(final ForgeWizardPage page, InputComponent<?, ?> input, final String inputName, Composite container) {
        Label label = new Label(container, 0);
        label.setText(this.getMnemonicLabel(input, true));
        final Text txt = new Text(container, 2626);
        GridData textareaLayoutData = new GridData(4, 4, true, true);
        textareaLayoutData.heightHint = 100;
        txt.setLayoutData((Object)textareaLayoutData);
        txt.setToolTipText(input.getDescription());
        ConverterFactory converterFactory = FurnaceService.INSTANCE.getConverterFactory();
        if (converterFactory != null) {
            Converter converter = converterFactory.getConverter(input.getValueType(), String.class);
            String value = (String)converter.convert(InputComponents.getValueFor(input));
            txt.setText(value == null ? "" : value);
        }
        txt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommandController controller = page.getController();
                try {
                    controller.setValueFor(inputName, (Object)txt.getText());
                }
                catch (Exception ex) {
                    ForgeUIPlugin.log(ex);
                    controller.setValueFor(inputName, null);
                }
            }
        });
        this.setupAutoCompleteForText(page.getWizard().getUIContext(), input, InputComponents.getCompleterFor(input), txt);
        Label dummy = new Label(container, 0);
        dummy.setText("");
        return txt;
    }

    @Override
    protected Class<String> getProducedType() {
        return String.class;
    }

    @Override
    protected String getSupportedInputType() {
        return "org.jboss.forge.inputType.TEXTAREA";
    }

    @Override
    protected Class<?>[] getSupportedInputComponentTypes() {
        return new Class[]{UIInput.class};
    }
}

