/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.console;

import java.beans.PropertyChangeListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.ui.internal.console.ForgeConsole;
import org.jboss.tools.forge.ui.internal.viewer.ForgeTextViewer;

public abstract class AbstractForgeConsole
implements ForgeConsole,
PropertyChangeListener,
DisposeListener {
    private ForgeRuntime runtime;
    private ForgeTextViewer textViewer;

    public AbstractForgeConsole(ForgeRuntime runtime) {
        this.runtime = runtime;
    }

    protected abstract ForgeTextViewer createTextViewer(Composite var1);

    protected ForgeTextViewer getTextViewer() {
        return this.textViewer;
    }

    @Override
    public ForgeRuntime getRuntime() {
        return this.runtime;
    }

    @Override
    public String getLabel() {
        return "Forge " + this.getRuntime().getVersion() + " - " + this.getRuntime().getType().name().toLowerCase();
    }

    @Override
    public Control createControl(Composite parent) {
        if (this.textViewer == null || this.textViewer.getControl().isDisposed()) {
            this.textViewer = this.createTextViewer(parent);
        }
        Control result = this.textViewer.getControl();
        this.getRuntime().addPropertyChangeListener((PropertyChangeListener)this);
        result.addDisposeListener((DisposeListener)this);
        return this.textViewer.getControl();
    }

    public void widgetDisposed(DisposeEvent event) {
        if (event.getSource() == this.getTextViewer().getControl()) {
            this.getRuntime().removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public Resource<?> getCurrentResource() {
        throw new UnsupportedOperationException();
    }
}

