/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.commands;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.ui.view.IRSEViewPart;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;
import org.jboss.tools.forge.ui.internal.commands.ForgeCommandPostProcessor;
import org.jboss.tools.forge.ui.internal.commands.ForgeCommandPostProcessorHelper;

public class CdPostProcessor
implements ForgeCommandPostProcessor {
    protected String getResourceToShow(Map<String, String> commandDetails) {
        return commandDetails.get("crn");
    }

    @Override
    public void postProcess(Map<String, String> commandDetails) {
        String crn = this.getResourceToShow(commandDetails);
        if (crn == null) {
            return;
        }
        Path path = new Path(crn);
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(crn));
        IFileInfo fileInfo = fileStore.fetchInfo();
        if (!fileInfo.exists()) {
            return;
        }
        Object resource = null;
        resource = fileInfo.isDirectory() ? ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)path) : ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        if (resource != null) {
            this.show((IResource)resource);
        }
        this.show(fileStore);
    }

    private void show(IFileStore fileStore) {
        IWorkbenchPage workbenchPage = ForgeCommandPostProcessorHelper.getActiveWorkbenchPage();
        IViewPart remoteSystemView = workbenchPage.findView("org.eclipse.rse.ui.view.systemView");
        if (remoteSystemView != null) {
            this.expandInRemoteSystemView(remoteSystemView, fileStore);
        }
    }

    private void show(IResource resource) {
        IWorkbenchPage workbenchPage = ForgeCommandPostProcessorHelper.getActiveWorkbenchPage();
        if (workbenchPage != null) {
            IViewPart packageExplorer;
            IViewPart projectExplorer = workbenchPage.findView("org.eclipse.ui.navigator.ProjectExplorer");
            if (projectExplorer != null) {
                this.show(projectExplorer, resource);
            }
            if ((packageExplorer = workbenchPage.findView("org.eclipse.jdt.ui.PackageExplorer")) == null && projectExplorer == null) {
                try {
                    packageExplorer = workbenchPage.showView("org.eclipse.jdt.ui.PackageExplorer");
                }
                catch (PartInitException e) {
                    ForgeUIPlugin.log(e);
                }
            }
            if (packageExplorer != null) {
                this.show(packageExplorer, resource);
            }
        }
    }

    private void show(IViewPart explorer, IResource resource) {
        if (explorer instanceof ISetSelectionTarget) {
            ((ISetSelectionTarget)explorer).selectReveal((ISelection)new StructuredSelection((Object)resource));
        }
    }

    private Viewer getViewer(IViewPart remoteSystemView) {
        if (remoteSystemView instanceof IRSEViewPart) {
            return ((IRSEViewPart)remoteSystemView).getRSEViewer();
        }
        return null;
    }

    private ArrayList<String> createSegmentNames(IFileStore fileStore) {
        ArrayList<String> result = new ArrayList<String>();
        while (fileStore.getParent() != null) {
            result.add(0, fileStore.getName());
            fileStore = fileStore.getParent();
        }
        result.add(0, "/");
        result.add(0, "Root");
        result.add(0, "Local Files");
        result.add(0, "Local");
        return result;
    }

    private void expandInRemoteSystemView(IViewPart remoteSystemView, IFileStore fileStore) {
        Viewer viewer = this.getViewer(remoteSystemView);
        Object input = viewer.getInput();
        ArrayList<String> names = this.createSegmentNames(fileStore);
        ArrayList<Object> treeSegments = new ArrayList<Object>();
        block0: for (String name : names) {
            if (input != null && input instanceof IAdaptable) {
                ISystemViewElementAdapter adapter = SystemAdapterHelpers.getViewAdapter((Object)input);
                if (adapter == null) continue;
                Object[] objectArray = adapter.getChildren((IAdaptable)input, null);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof IAdaptable && (adapter = SystemAdapterHelpers.getViewAdapter((Object)object)) != null && name.equals(adapter.getText(object))) {
                        input = object;
                        treeSegments.add(input);
                        continue block0;
                    }
                    ++n2;
                }
                continue;
            }
            treeSegments.clear();
            break;
        }
        TreePath treePath = new TreePath(treeSegments.toArray());
        viewer.setSelection((ISelection)new StructuredSelection((Object)treePath));
        if (viewer instanceof TreeViewer) {
            ((TreeViewer)viewer).expandToLevel((Object)treePath, 1);
        }
    }
}

