/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.actions;

import java.net.URL;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;
import org.jboss.tools.forge.ui.internal.actions.ForgeConsoleShowAction;
import org.jboss.tools.forge.ui.internal.console.ForgeConsole;
import org.jboss.tools.forge.ui.internal.console.ForgeConsoleManager;
import org.jboss.tools.forge.ui.internal.part.ForgeConsoleView;

public class ForgeConsoleDropdownAction
extends Action
implements IMenuCreator {
    private ForgeConsoleView forgeConsoleView = null;
    private Menu menu = null;

    public ForgeConsoleDropdownAction(ForgeConsoleView forgeConsoleView) {
        this.forgeConsoleView = forgeConsoleView;
        this.setImageDescriptor(this.createImageDescriptor());
        this.setToolTipText("Select Forge Runtime");
        this.setMenuCreator(this);
    }

    public void dispose() {
    }

    public void runWithEvent(Event event) {
        if (event.widget instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)event.widget;
            ToolBar control = toolItem.getParent();
            Menu menu = this.getMenu((Control)control);
            Rectangle bounds = toolItem.getBounds();
            Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
            menu.setLocation(control.toDisplay(topLeft));
            menu.setVisible(true);
        }
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        ForgeConsole[] forgeConsoleArray = ForgeConsoleManager.INSTANCE.getConsoles();
        int n = forgeConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ForgeConsole forgeConsole = forgeConsoleArray[n2];
            this.addAction(this.menu, forgeConsole);
            ++n2;
        }
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    private void addAction(Menu menu, ForgeConsole forgeConsole) {
        ForgeConsoleShowAction action = new ForgeConsoleShowAction(this.forgeConsoleView, forgeConsole);
        action.setChecked(forgeConsole.equals(this.forgeConsoleView.getConsole()));
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(menu, -1);
    }

    private ImageDescriptor createImageDescriptor() {
        URL url = ForgeUIPlugin.getDefault().getBundle().getEntry("icons/forge.png");
        return ImageDescriptor.createFromURL((URL)url);
    }
}

