/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.livegraph.views;

import java.util.HashMap;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.zest.layouts.algorithms.DirectedGraphLayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.InternalNode;
import org.eclipse.zest.layouts.dataStructures.InternalRelationship;

public class ExtendedDirectedGraphLayoutAlgorithm
extends DirectedGraphLayoutAlgorithm {
    public ExtendedDirectedGraphLayoutAlgorithm(int styles) {
        super(styles);
    }

    protected void applyLayoutInternal(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double boundsX, double boundsY, double boundsWidth, double boundsHeight) {
        HashMap<InternalNode, Node> mapping = new HashMap<InternalNode, Node>(entitiesToLayout.length);
        DirectedGraph graph = new DirectedGraph();
        InternalNode[] internalNodeArray = entitiesToLayout;
        int n = entitiesToLayout.length;
        int n2 = 0;
        while (n2 < n) {
            InternalNode internalNode = internalNodeArray[n2];
            Node node = new Node((Object)internalNode);
            int height = new Double(internalNode.getHeightInLayout()).intValue();
            int width = new Double(internalNode.getWidthInLayout()).intValue();
            if ((this.layout_styles & 0x100) == 256) {
                node.setSize(new Dimension(height, width));
            } else {
                node.setSize(new Dimension(width, height));
            }
            mapping.put(internalNode, node);
            graph.nodes.add((Object)node);
            ++n2;
        }
        internalNodeArray = relationshipsToConsider;
        n = relationshipsToConsider.length;
        n2 = 0;
        while (n2 < n) {
            InternalNode relationship = internalNodeArray[n2];
            Node source = (Node)mapping.get(relationship.getSource());
            Node dest = (Node)mapping.get(relationship.getDestination());
            if (source != null && dest != null) {
                Edge edge = new Edge((Object)relationship, source, dest);
                graph.edges.add((Object)edge);
            }
            ++n2;
        }
        DirectedGraphLayout directedGraphLayout = new DirectedGraphLayout();
        directedGraphLayout.visit(graph);
        for (Node node : graph.nodes) {
            InternalNode internalNode = (InternalNode)node.data;
            if ((this.layout_styles & 0x100) == 256) {
                internalNode.setInternalLocation((double)node.y, (double)node.x);
                continue;
            }
            internalNode.setInternalLocation((double)node.x, (double)node.y);
        }
        this.updateLayoutLocations(entitiesToLayout);
    }
}

