/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.ui.actions;

import com.atlassian.connector.eclipse.internal.jira.core.JiraClientFactory;
import com.atlassian.connector.eclipse.internal.jira.core.JiraTaskDataHandler;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraIssue;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClient;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraRemoteMessageException;
import com.atlassian.connector.eclipse.internal.jira.ui.IJiraTask;
import com.atlassian.connector.eclipse.internal.jira.ui.actions.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJiraAction
extends BaseSelectionListenerAction
implements IObjectActionDelegate {
    private IStructuredSelection selection;
    private IWorkbenchPart targetPart;

    public AbstractJiraAction(String text) {
        super(text);
    }

    public void run(IAction action) {
        if (this.selection != null && !this.selection.isEmpty()) {
            ArrayList<IJiraTask> tasks = new ArrayList<IJiraTask>();
            for (Object sel : this.selection) {
                if (!(sel instanceof IJiraTask)) continue;
                tasks.add((IJiraTask)sel);
            }
            if (!tasks.isEmpty()) {
                this.doAction(tasks);
            }
        }
    }

    protected abstract void doAction(List<IJiraTask> var1);

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
    }

    protected static JiraIssue getIssue(ITask task) throws CoreException {
        TaskData taskData = TasksUi.getTaskDataManager().getTaskData(task);
        return JiraTaskDataHandler.buildJiraIssue((TaskData)taskData);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public IWorkbenchPart getTargetPart() {
        return this.targetPart;
    }

    protected static JiraClient getClient(ITask task) {
        TaskRepository repo = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        return JiraClientFactory.getDefault().getJiraClient(repo);
    }

    protected static AbstractRepositoryConnector getConnector(ITask task) {
        return TasksUi.getRepositoryConnector((String)task.getConnectorKind());
    }

    protected static void handleError(final String message, final Throwable e) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)WorkbenchUtil.getShell(), (String)"Atlassian JIRA Connector", (String)message);
                StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.jira.ui", message, e));
            }
        });
    }

    protected static void handleInformation(final String message) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)WorkbenchUtil.getShell(), (String)"Atlassian JIRA Connector", (String)message);
                StatusHandler.log((IStatus)new Status(1, "com.atlassian.connector.eclipse.jira.ui", message));
            }
        });
    }

    protected static void handleErrorWithDetails(final String message, final Throwable e) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                Throwable t = e;
                String m = message;
                if (e.getMessage().contains("The likely cause is that somebody has changed the issue recently")) {
                    m = String.valueOf(m) + " \n" + Messages.JiraAction_Issue_Refresh_Try_Again;
                } else if (e.getMessage().contains("No workflow action with id")) {
                    m = String.valueOf(m) + " \n" + Messages.JiraAction_Issue_Refresh;
                } else if (e instanceof JiraRemoteMessageException) {
                    JiraRemoteMessageException jiraException = (JiraRemoteMessageException)e;
                    if (jiraException.getHtmlMessage().contains("The likely cause is that somebody has changed the issue recently")) {
                        m = String.valueOf(m) + ". \n" + Messages.JiraAction_Issue_Changed + " \n" + Messages.JiraAction_Issue_Refresh_Try_Again;
                    } else if (jiraException.getHtmlMessage().contains("No workflow action with id")) {
                        m = String.valueOf(m) + " \n" + Messages.JiraAction_Issue_Refresh;
                    }
                }
                if (e.getMessage().length() > 300) {
                    t = new Exception(String.valueOf(e.getMessage().substring(0, 300)) + "...", e);
                }
                Status status = new Status(4, "com.atlassian.connector.eclipse.jira.ui", m, t);
                StatusManager.getManager().handle((IStatus)status, 7);
            }
        });
    }
}

