/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.ui;

import com.atlassian.connector.eclipse.internal.jira.core.model.JiraFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ContentFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.FilterDefinition;
import com.atlassian.connector.eclipse.internal.jira.core.util.JiraUtil;
import java.util.StringTokenizer;
import org.eclipse.mylyn.internal.tasks.core.AbstractSearchHandler;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class JiraSearchHandler
extends AbstractSearchHandler {
    private static final int MAX_LENGTH = 950;

    public String getConnectorKind() {
        return "jira";
    }

    public boolean queryForText(TaskRepository taskRepository, IRepositoryQuery query, TaskData taskData, String searchString) {
        String preparedSearchString = JiraSearchHandler.prepareJqlSearchString(searchString);
        FilterDefinition filter = new FilterDefinition();
        filter.setContentFilter(new ContentFilter(preparedSearchString, false, true, false, true));
        JiraUtil.setQuery((TaskRepository)taskRepository, (IRepositoryQuery)query, (JiraFilter)filter);
        return true;
    }

    public static String prepareSearchString(String searchString) {
        StringBuilder sb = new StringBuilder(950);
        StringTokenizer t = new StringTokenizer(searchString, " :\n\t()$");
        while (t.hasMoreTokens() && sb.length() < 930) {
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            int remaining = 950 - sb.length();
            String token = t.nextToken();
            if (token.length() > remaining) {
                sb.append(token.substring(0, remaining));
                sb.append("*");
                continue;
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public static String prepareJqlSearchString(String input) {
        StringBuilder sb = new StringBuilder(950);
        StringTokenizer t = new StringTokenizer(input, "\n\t");
        while (t.hasMoreTokens() && sb.length() < 900) {
            String token;
            int remaining = 950 - sb.length();
            if (sb.length() > 0) {
                sb.append("*");
            }
            if ((token = t.nextToken()).length() > remaining) {
                sb.append(token.substring(0, remaining));
                sb.append("*");
                continue;
            }
            sb.append(token);
        }
        sb.insert(0, "\\\"");
        sb.append("\\\"");
        String output = sb.toString().replaceAll("([():])", "\\\\\\\\$1");
        return output;
    }
}

