/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core.scriptpath;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import tern.eclipse.ide.core.scriptpath.ITernScriptPath;
import tern.utils.StringUtils;

public abstract class AbstractTernScriptPath
implements ITernScriptPath {
    private final IResource resource;
    private final ITernScriptPath.ScriptPathsType type;
    private final boolean external;
    private final String externalLabel;

    public AbstractTernScriptPath(IResource resource, ITernScriptPath.ScriptPathsType type, String externalLabel) {
        this.resource = resource;
        this.type = type;
        this.external = !StringUtils.isEmpty((String)externalLabel);
        this.externalLabel = externalLabel;
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }

    @Override
    public IProject getOwnerProject() {
        return this.getResource().getProject();
    }

    @Override
    public String getPath() {
        return this.getResource().getProjectRelativePath().toString();
    }

    @Override
    public ITernScriptPath.ScriptPathsType getType() {
        return this.type;
    }

    @Override
    public boolean isExternal() {
        return this.external;
    }

    @Override
    public String getExternalLabel() {
        return this.externalLabel;
    }
}

