/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.w3c.dom.Node;
import tern.TernException;
import tern.TernFileManager;
import tern.TernProject;
import tern.angular.protocol.completions.TernAngularCompletionsQuery;
import tern.eclipse.ide.core.IDETernFileManager;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.ITernConsoleConnector;
import tern.eclipse.ide.core.ITernProjectLifecycleListener;
import tern.eclipse.ide.core.ITernServerPreferencesListener;
import tern.eclipse.ide.core.ITernServerType;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.core.TernNature;
import tern.eclipse.ide.core.scriptpath.ITernScriptPath;
import tern.eclipse.ide.core.utils.FileUtils;
import tern.eclipse.ide.internal.core.TernConsoleConnectorManager;
import tern.eclipse.ide.internal.core.TernNatureAdaptersManager;
import tern.eclipse.ide.internal.core.TernProjectLifecycleManager;
import tern.eclipse.ide.internal.core.Trace;
import tern.eclipse.ide.internal.core.preferences.TernCorePreferencesSupport;
import tern.eclipse.ide.internal.core.scriptpath.DOMElementsScriptPath;
import tern.eclipse.ide.internal.core.scriptpath.FolderScriptPath;
import tern.eclipse.ide.internal.core.scriptpath.JSFileScriptPath;
import tern.eclipse.ide.internal.core.scriptpath.ProjectScriptPath;
import tern.server.IResponseHandler;
import tern.server.ITernServer;
import tern.server.ITernServerListener;
import tern.server.TernServerAdapter;
import tern.server.protocol.JsonHelper;
import tern.server.protocol.TernDoc;
import tern.server.protocol.TernFile;
import tern.server.protocol.TernQuery;
import tern.server.protocol.completions.ITernCompletionCollector;
import tern.server.protocol.definition.ITernDefinitionCollector;
import tern.server.protocol.lint.ITernLintCollector;
import tern.server.protocol.type.ITernTypeCollector;

public class IDETernProject
extends TernProject<IFile>
implements IIDETernProject,
ITernServerPreferencesListener {
    private static final int MAX_FILES = 20;
    private static final String PATH_JSON_FIELD = "path";
    private static final String TYPE_JSON_FIELD = "type";
    private static final String SCRIPT_PATHS_JSON_FIELD = "scriptPaths";
    private static final String IDE_JSON_FIELD = "ide";
    private static final long serialVersionUID = 1L;
    private static final QualifiedName TERN_PROJECT = new QualifiedName("tern.eclipse.ide.core.sessionprops", "TernProject");
    private final IProject project;
    private ITernServer ternServer;
    private final List<ITernScriptPath> scriptPaths;
    private final Object lock = new Object();
    private final Map<String, Object> data;
    private final List<ITernServerListener> listeners;

    IDETernProject(IProject project) throws CoreException {
        super(project.getLocation().toFile());
        this.project = project;
        super.setFileManager((TernFileManager)new IDETernFileManager(this.getProject()));
        project.setSessionProperty(TERN_PROJECT, (Object)this);
        this.scriptPaths = new ArrayList<ITernScriptPath>();
        this.data = new HashMap<String, Object>();
        this.listeners = new ArrayList<ITernServerListener>();
        TernCorePlugin.getTernServerTypeManager().addServerPreferencesListener(this);
        this.ensureNatureIsConfigured();
    }

    public static IDETernProject getTernProject(IProject project) throws CoreException {
        if (!IDETernProject.hasTernNature(project)) {
            throw new CoreException((IStatus)new Status(4, "tern.eclipse.ide.core", "The project " + project.getName() + " is not a tern project."));
        }
        IDETernProject ternProject = (IDETernProject)project.getSessionProperty(TERN_PROJECT);
        if (ternProject == null) {
            ternProject = new IDETernProject(project);
            try {
                ternProject.load();
            }
            catch (IOException e) {
                Trace.trace((byte)3, "Error while loading tern project", e);
            }
        }
        return ternProject;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    private ITernServer getTernServer() {
        if (this.isServerDisposed()) {
            try {
                ITernServerType type = TernCorePreferencesSupport.getInstance().getServerType();
                this.ternServer = type.createServer(this);
                this.ternServer.addServerListener((ITernServerListener)new TernServerAdapter(){

                    public void onStop(ITernServer server) {
                        IDETernProject.this.getFileManager().cleanIndexedFiles();
                    }
                });
                this.copyListeners();
                this.configureConsole();
            }
            catch (Exception e) {
                Trace.trace((byte)3, "Error while creating tern server", e);
            }
        }
        return this.ternServer;
    }

    @Override
    public boolean isServerDisposed() {
        return this.ternServer == null || this.ternServer.isDisposed();
    }

    public static boolean hasTernNature(IProject project) {
        return TernNatureAdaptersManager.getManager().hasTernNature(project);
    }

    public void load() throws IOException {
        try {
            TernProjectLifecycleManager.getManager().fireTernProjectLifeCycleListenerChanged(this, ITernProjectLifecycleListener.LifecycleEventType.onLoadBefore);
            super.load();
            this.loadIDEInfos();
            this.initAdaptedNaturesInfos();
        }
        finally {
            TernProjectLifecycleManager.getManager().fireTernProjectLifeCycleListenerChanged(this, ITernProjectLifecycleListener.LifecycleEventType.onLoadAfter);
        }
    }

    private void loadIDEInfos() {
        JsonArray jsonScripts;
        this.scriptPaths.clear();
        JsonObject ide = (JsonObject)super.get(IDE_JSON_FIELD);
        if (ide != null && (jsonScripts = (JsonArray)ide.get(SCRIPT_PATHS_JSON_FIELD)) != null) {
            JsonObject jsonScript = null;
            String type = null;
            String path = null;
            for (Object object : jsonScripts) {
                IResource resource;
                jsonScript = (JsonObject)object;
                type = JsonHelper.getString((JsonObject)jsonScript, (String)TYPE_JSON_FIELD);
                path = JsonHelper.getString((JsonObject)jsonScript, (String)PATH_JSON_FIELD);
                if (type == null || path == null) continue;
                ITernScriptPath.ScriptPathsType pathType = ITernScriptPath.ScriptPathsType.getType(type);
                if (pathType == null) {
                    pathType = ITernScriptPath.ScriptPathsType.FILE;
                }
                if (pathType == null || (resource = this.getResource(path, pathType)) == null || !resource.exists()) continue;
                this.scriptPaths.add(this.createScriptPath(resource, pathType));
            }
        }
    }

    private void initAdaptedNaturesInfos() {
        try {
            TernNatureAdaptersManager.getManager().addDefaultModules(this);
        }
        catch (CoreException e) {
            Trace.trace((byte)3, "Error while configuring default tern project modules", e);
            return;
        }
        try {
            this.saveIfNeeded();
        }
        catch (IOException e) {
            Trace.trace((byte)3, "Error while saving tern project", e);
        }
    }

    private IResource getResource(String path, ITernScriptPath.ScriptPathsType pathType) {
        switch (pathType) {
            case FILE: {
                return this.getProject().getFile(path);
            }
            case FOLDER: {
                return this.getProject().getFolder(path);
            }
            case PROJECT: {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(path);
            }
        }
        throw new UnsupportedOperationException("Cannot retrieve resource from the type=" + (Object)((Object)pathType) + " of the path=" + path);
    }

    public void save() throws IOException {
        try {
            TernProjectLifecycleManager.getManager().fireTernProjectLifeCycleListenerChanged(this, ITernProjectLifecycleListener.LifecycleEventType.onSaveBefore);
            this.saveIDEInfos();
            super.save();
            this.disposeServer();
        }
        finally {
            TernProjectLifecycleManager.getManager().fireTernProjectLifeCycleListenerChanged(this, ITernProjectLifecycleListener.LifecycleEventType.onSaveAfter);
        }
    }

    private void saveIDEInfos() {
        JsonObject ide = new JsonObject();
        if (this.scriptPaths.size() > 0) {
            JsonArray jsonScripts = new JsonArray();
            for (ITernScriptPath scriptPath : this.scriptPaths) {
                if (scriptPath.isExternal()) continue;
                JsonObject jsonScript = new JsonObject();
                jsonScript.add(TYPE_JSON_FIELD, scriptPath.getType().name());
                jsonScript.add(PATH_JSON_FIELD, scriptPath.getPath());
                jsonScripts.add((JsonValue)jsonScript);
            }
            ide.add(SCRIPT_PATHS_JSON_FIELD, (JsonValue)jsonScripts);
        }
        super.set(IDE_JSON_FIELD, (JsonValue)ide);
    }

    @Override
    public Collection<ITernScriptPath> getScriptPaths() {
        return this.scriptPaths;
    }

    @Override
    public ITernScriptPath createScriptPath(IResource resource, ITernScriptPath.ScriptPathsType type) {
        return this.createScriptPath(resource, type, null);
    }

    private ITernScriptPath createScriptPath(IResource resource, ITernScriptPath.ScriptPathsType type, String external) {
        switch (type) {
            case FOLDER: {
                return new FolderScriptPath((IFolder)resource, external);
            }
            case FILE: {
                IFile file = (IFile)resource;
                if (FileUtils.isJSFile((IResource)file)) {
                    return new JSFileScriptPath(file, external);
                }
                return new DOMElementsScriptPath(file, external);
            }
            case PROJECT: {
                return new ProjectScriptPath((IProject)resource, this.getProject(), external);
            }
        }
        throw new UnsupportedOperationException("Cannot create script path for the given type " + (Object)((Object)type));
    }

    @Override
    public void setScriptPaths(List<ITernScriptPath> scriptPaths) throws IOException {
        this.scriptPaths.clear();
        this.scriptPaths.addAll(scriptPaths);
        this.save();
    }

    @Override
    public ITernScriptPath addExternalScriptPath(IResource resource, ITernScriptPath.ScriptPathsType type, String external) throws IOException {
        ITernScriptPath path = this.createScriptPath(resource, type, external);
        this.scriptPaths.add(path);
        this.saveIfNeeded();
        return path;
    }

    @Override
    public void removeExternalScriptPaths(String external) {
        ArrayList<ITernScriptPath> initialScriptPaths = new ArrayList<ITernScriptPath>(this.scriptPaths);
        for (ITernScriptPath scriptPath : initialScriptPaths) {
            if (!external.equals(scriptPath.getExternalLabel())) continue;
            this.scriptPaths.remove(scriptPath);
        }
    }

    public boolean equals(Object value) {
        if (value instanceof IDETernProject) {
            return ((IDETernProject)value).getProject().equals((Object)this.getProject());
        }
        return super.equals(value);
    }

    @Override
    public ITernScriptPath getScriptPath(String path) {
        for (ITernScriptPath scriptPath : this.scriptPaths) {
            if (!scriptPath.getPath().equals(path)) continue;
            return scriptPath;
        }
        return null;
    }

    public boolean isTraceOnConsole() {
        return TernCorePreferencesSupport.getInstance().isTraceOnConsole(this.project);
    }

    @Override
    public void configureConsole() {
        ITernConsoleConnector connector;
        if (this.ternServer != null && (connector = TernConsoleConnectorManager.getManager().getConnector(this.ternServer)) != null) {
            if (this.isTraceOnConsole()) {
                connector.connectToConsole(this.ternServer, this);
            } else {
                connector.disconnectToConsole(this.ternServer, this);
            }
        }
    }

    @Override
    public void request(TernAngularCompletionsQuery query, JsonArray names, ITernCompletionCollector collector) throws IOException, TernException {
        this.syncFiles(new TernDoc(), names, null);
        TernDoc doc = new TernDoc((TernQuery)query);
        this.request(doc, collector);
    }

    @Override
    public void request(TernQuery query, JsonArray names, ITernScriptPath scriptPath, ITernCompletionCollector collector) throws IOException, TernException {
        this.syncFiles(new TernDoc(), names, scriptPath);
        TernDoc doc = new TernDoc(query);
        this.request(doc, collector);
    }

    @Override
    public void request(TernQuery query, JsonArray names, Node domNode, IFile domFile, IDocument document, ITernCompletionCollector collector) throws IOException, TernException {
        this.synchFiles(names, domNode, domFile, document, new TernDoc());
        TernDoc doc = new TernDoc(query);
        this.request(doc, collector);
    }

    @Override
    public void request(TernQuery query, IFile file, IDocument document, int startOffset, ITernCompletionCollector collector) throws IOException, TernException {
        this.synchFiles(file, document, new TernDoc());
        TernDoc doc = new TernDoc(query);
        this.request(doc, collector);
    }

    private void request(TernDoc doc, ITernCompletionCollector collector) throws TernException {
        ITernServer server = this.getTernServer();
        server.request(doc, collector);
    }

    @Override
    public void request(TernQuery query, JsonArray names, ITernScriptPath scriptPath, ITernDefinitionCollector collector) throws IOException, TernException {
        this.syncFiles(new TernDoc(), names, scriptPath);
        TernDoc doc = new TernDoc(query);
        this.request(doc, collector);
    }

    @Override
    public void request(TernQuery query, JsonArray names, Node domNode, IFile domFile, IDocument document, ITernDefinitionCollector collector) throws IOException, TernException {
        this.synchFiles(names, domNode, domFile, document, new TernDoc());
        TernDoc doc = new TernDoc(query);
        this.request(doc, collector);
    }

    @Override
    public void request(TernQuery query, IFile file, IDocument document, ITernDefinitionCollector collector) throws IOException, TernException {
        this.synchFiles(file, document, new TernDoc());
        TernDoc doc = new TernDoc(query);
        this.request(doc, collector);
    }

    private void request(TernDoc doc, ITernDefinitionCollector collector) throws TernException {
        ITernServer server = this.getTernServer();
        server.request(doc, collector);
    }

    @Override
    public void request(TernQuery query, IFile file, IDocument document, ITernLintCollector collector) throws IOException, TernException {
        this.synchFiles(file, document, new TernDoc());
        TernDoc doc = new TernDoc(query);
        String name = this.getFileManager().getFileName((Object)file);
        query.setFile(name);
        this.request(doc, collector);
    }

    private void request(TernDoc doc, ITernLintCollector collector) throws TernException {
        ITernServer server = this.getTernServer();
        server.request(doc, collector);
    }

    @Override
    public void request(TernQuery query, JsonArray names, ITernScriptPath scriptPath, ITernTypeCollector collector) throws IOException, TernException {
        this.syncFiles(new TernDoc(), names, scriptPath);
        TernDoc doc = new TernDoc(query);
        this.request(doc, collector);
    }

    @Override
    public void request(TernQuery query, JsonArray names, Node domNode, IFile domFile, IDocument document, ITernTypeCollector collector) throws IOException, TernException {
        this.synchFiles(names, domNode, domFile, document, new TernDoc());
        TernDoc doc = new TernDoc(query);
        this.request(doc, collector);
    }

    @Override
    public void request(TernQuery query, IFile file, IDocument document, int startOffset, ITernTypeCollector collector) throws IOException, TernException {
        this.synchFiles(file, document, new TernDoc());
        TernDoc doc = new TernDoc(query);
        this.request(doc, collector);
    }

    private void request(TernDoc doc, ITernTypeCollector collector) throws TernException {
        ITernServer server = this.getTernServer();
        server.request(doc, collector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFiles(TernDoc doc, JsonArray names, ITernScriptPath scriptPath) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            for (ITernScriptPath currentScriptPath : this.scriptPaths) {
                currentScriptPath.updateFiles(this.getFileManager(), doc, this.getNames(names, currentScriptPath, scriptPath));
            }
            this.synchFiles(doc);
        }
    }

    private JsonArray getNames(JsonArray names, ITernScriptPath currentScriptPath, ITernScriptPath scriptPath) {
        if (names != null) {
            if (scriptPath == null || currentScriptPath.equals(scriptPath)) {
                return names;
            }
            return null;
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchFiles(IFile file, IDocument document, TernDoc doc) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.syncFiles(doc, null, null);
            if (file != null && file.exists()) {
                String name = this.getFileManager().getFileName((Object)file);
                String text = document.get();
                boolean isHTML = FileUtils.isHTMLFile((IResource)file);
                doc.addFile(name, text, isHTML, null);
                TernQuery query = doc.getQuery();
                if (query != null) {
                    query.setFile(name);
                }
            }
            this.synchFiles(doc);
        }
    }

    private void synchFiles(TernDoc doc) {
        if (doc.hasFiles()) {
            JsonArray files = doc.getFiles();
            if (files.size() > 20) {
                TernDoc newDoc = new TernDoc();
                int i = 0;
                while (i < files.size()) {
                    newDoc.addFile((TernFile)files.get(i));
                    if (i > 0 && i % 20 == 0) {
                        this.request(newDoc);
                        newDoc.cleanFiles();
                    }
                    ++i;
                }
                if (newDoc.hasFiles()) {
                    this.request(newDoc);
                }
            } else {
                this.request(doc);
            }
            doc.cleanFiles();
        }
    }

    public void request(TernDoc doc) {
        ITernServer server = this.getTernServer();
        server.request(doc, new IResponseHandler(){

            public void onSuccess(Object data, String dataAsJsonString) {
            }

            public void onError(String error) {
                Trace.trace((byte)3, error);
            }

            public boolean isDataAsJsonString() {
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchFiles(JsonArray names, Node domNode, IFile domFile, IDocument document, TernDoc doc) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean hasJS = this.getFileManager().updateFiles(domNode, (Object)domFile, doc, names);
            if (!doc.hasFiles()) {
                this.syncFiles(doc, names, null);
            }
            if (hasJS) {
                this.synchFiles(domFile, document, doc);
            }
            this.synchFiles(doc);
        }
    }

    @Override
    public void disposeServer() {
        if (!this.isServerDisposed() && this.ternServer != null) {
            this.ternServer.dispose();
            this.ternServer = null;
        }
    }

    @Override
    public <T> T getData(String key) {
        return (T)this.data.get(key);
    }

    @Override
    public void setData(String key, Object value) {
        this.data.put(key, value);
    }

    private void ensureNatureIsConfigured() throws CoreException {
        TernNature tempTernNature = new TernNature();
        tempTernNature.setProject(this.project);
        if (!tempTernNature.isConfigured()) {
            tempTernNature.configure();
        }
    }

    @Override
    public void serverPreferencesChanged(IProject project) {
        if (project == null || this.getProject().equals((Object)project)) {
            this.disposeServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServerListener(ITernServerListener listener) {
        List<ITernServerListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
        this.copyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServerListener(ITernServerListener listener) {
        List<ITernServerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    private void copyListeners() {
        if (this.ternServer != null) {
            for (ITernServerListener listener : this.listeners) {
                this.ternServer.addServerListener(listener);
            }
        }
    }
}

