/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.navigator.actions;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.ui.SpringUIUtils;
import org.springframework.ide.eclipse.ui.navigator.actions.AbstractNavigatorAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;

public class OpenPropertiesAction
extends AbstractNavigatorAction {
    private IProject project;
    private IModelElement modelElement;

    public OpenPropertiesAction(ICommonActionExtensionSite site) {
        super(site);
        this.setText("&Properties");
    }

    public boolean isEnabled(IStructuredSelection selection) {
        if (selection.size() == 1) {
            Object sElement = selection.getFirstElement();
            IProject project = null;
            if (sElement instanceof IWebflowProject) {
                project = ((IWebflowProject)sElement).getProject();
                this.modelElement = null;
            } else if (sElement instanceof IWebflowConfig) {
                project = ((IWebflowConfig)sElement).getProject().getProject();
                this.modelElement = (IWebflowConfig)sElement;
            } else if (sElement instanceof IFile && WebflowModelUtils.isWebflowConfig((IResource)((IFile)sElement)) && "org.springframework.ide.eclipse.webflow.ui.navigator.springExplorerContent".equals(this.getActionSite().getExtensionId())) {
                project = WebflowModelUtils.getWebflowConfig((IFile)((IFile)sElement)).getProject().getProject();
                this.modelElement = WebflowModelUtils.getWebflowConfig((IFile)((IFile)sElement));
            }
            if (project != null) {
                this.project = project;
                return true;
            }
        }
        return false;
    }

    public void run() {
        HashMap<String, IModelElement> data = new HashMap<String, IModelElement>();
        if (this.modelElement != null) {
            data.put("org.springframework.ide.eclipse.webflow.ui.properties.projectPropertyPage.selectedResource", this.modelElement);
        }
        SpringUIUtils.showPreferenceDialog((String)"org.springframework.ide.eclipse.webflow.ui.properties.projectPropertyPage", (IProject)this.project, data);
    }
}

