/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.beans.ui.navigator.BeansNavigatorLabelProvider;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;

public class WebflowNavigatorLabelProvider
extends BeansNavigatorLabelProvider {
    public String getDescription(Object element) {
        if (element instanceof IWebflowProject) {
            return "Web Flow - " + ((IWebflowProject)element).getProject().getName();
        }
        if (element instanceof IWebflowConfig) {
            return this.getFileDescription(((IWebflowConfig)element).getResource());
        }
        if (element instanceof IFile) {
            return this.getFileDescription((IFile)element);
        }
        return super.getDescription(element);
    }

    protected String getFileDescription(IFile file) {
        return String.valueOf(file.getName()) + " - " + file.getFullPath().makeRelative().removeLastSegments(1).toString();
    }

    protected Image getImage(Object element, Object parentElement) {
        if (element instanceof IWebflowConfig) {
            return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.spring_webflow_obj.gif");
        }
        if (element instanceof IWebflowProject) {
            return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.virtual_folder_obj.gif");
        }
        return super.getImage(element, parentElement);
    }

    protected String getText(Object element, Object parentElement) {
        if (element instanceof IWebflowProject) {
            return "Web Flow";
        }
        if (element instanceof IWebflowConfig) {
            IWebflowConfig config = (IWebflowConfig)element;
            if (config.getName() != null) {
                return config.getName();
            }
            return this.getFileLabel(config.getResource());
        }
        if (element instanceof IFile && parentElement != null) {
            return this.getFileLabel((IFile)element);
        }
        return super.getText(element, parentElement);
    }

    private String getFileLabel(IFile file) {
        return String.valueOf(file.getName()) + " - " + file.getProjectRelativePath().removeLastSegments(1).toString();
    }
}

