/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java.typehierarchy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.springframework.ide.eclipse.core.java.typehierarchy.ClasspathElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathElementZip
implements ClasspathElement {
    private ZipFile zipFile;
    private String zipFileName;
    private Set<String> knownPackageNames;
    private long lastModified;
    private static Map<String, PackageCacheEntry> PackageCache = new ConcurrentHashMap<String, PackageCacheEntry>();

    public ClasspathElementZip(String zipFileName) {
        this.zipFileName = zipFileName;
    }

    @Override
    public InputStream getStream(String fullyQualifiedClassFileName, String packageName, String classFileName) throws Exception {
        if (!this.isPackage(packageName)) {
            return null;
        }
        ZipEntry entry = this.zipFile.getEntry(fullyQualifiedClassFileName);
        if (entry != null) {
            return this.zipFile.getInputStream(entry);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        ClasspathElementZip classpathElementZip = this;
        synchronized (classpathElementZip) {
            if (this.zipFile != null) {
                try {
                    this.zipFile.close();
                }
                catch (IOException iOException) {}
                this.zipFile = null;
            }
            this.knownPackageNames = null;
        }
    }

    public long lastModified() {
        if (this.lastModified == 0L) {
            this.lastModified = new File(this.zipFile.getName()).lastModified();
        }
        return this.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPackage(String qualifiedPackageName) {
        if (this.knownPackageNames != null) {
            return this.knownPackageNames.contains(qualifiedPackageName);
        }
        try {
            ClasspathElementZip classpathElementZip = this;
            synchronized (classpathElementZip) {
                if (this.zipFile == null) {
                    this.zipFile = new ZipFile(this.zipFileName);
                }
                this.knownPackageNames = this.findPackageSet();
            }
        }
        catch (Exception exception) {
            this.knownPackageNames = Collections.newSetFromMap(new ConcurrentHashMap());
        }
        return this.knownPackageNames.contains(qualifiedPackageName);
    }

    private Set<String> findPackageSet() {
        long lastModified = this.lastModified();
        long fileSize = new File(this.zipFileName).length();
        PackageCacheEntry cacheEntry = PackageCache.get(this.zipFileName);
        if (cacheEntry != null && cacheEntry.lastModified == lastModified && cacheEntry.fileSize == fileSize) {
            return cacheEntry.packageSet;
        }
        Set<String> packageSet = Collections.newSetFromMap(new ConcurrentHashMap());
        packageSet.add("");
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        block0: while (e.hasMoreElements()) {
            String fileName = e.nextElement().getName();
            int last = fileName.lastIndexOf(47);
            while (last > 0) {
                String packageName = fileName.substring(0, last);
                if (!packageSet.add(packageName)) continue block0;
                last = packageName.lastIndexOf(47);
            }
        }
        PackageCache.put(this.zipFileName, new PackageCacheEntry(lastModified, fileSize, packageSet));
        return packageSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PackageCacheEntry {
        long lastModified;
        long fileSize;
        Set<String> packageSet;

        public PackageCacheEntry(long lastModified, long fileSize, Set<String> packageSet) {
            this.lastModified = lastModified;
            this.fileSize = fileSize;
            this.packageSet = packageSet;
        }
    }
}

