/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java.typehierarchy;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.java.ProjectClassLoaderCache;
import org.springframework.ide.eclipse.core.java.typehierarchy.BytecodeTypeHierarchyClassReader;
import org.springframework.ide.eclipse.core.java.typehierarchy.ClasspathElement;
import org.springframework.ide.eclipse.core.java.typehierarchy.ClasspathElementDirectory;
import org.springframework.ide.eclipse.core.java.typehierarchy.ClasspathElementZip;
import org.springframework.ide.eclipse.core.java.typehierarchy.TypeHierarchyClassReader;
import org.springframework.ide.eclipse.core.java.typehierarchy.TypeHierarchyClassReaderFactory;

public class BytecodeTypeHierarchyClassReaderFactory
implements TypeHierarchyClassReaderFactory {
    public TypeHierarchyClassReader createClassReader(IProject project) {
        List<URL> urls = ProjectClassLoaderCache.getClassPathUrls(project, null);
        ArrayList<ClasspathElement> locations = new ArrayList<ClasspathElement>();
        HashSet<URL> usedURLs = new HashSet<URL>();
        for (URL url : urls) {
            if (usedURLs.contains(url)) continue;
            if (url.toString().endsWith(".jar") || url.toString().endsWith(".zip")) {
                try {
                    String path = url.toURI().getPath();
                    locations.add(new ClasspathElementZip(path));
                    usedURLs.add(url);
                }
                catch (Exception e) {
                    SpringCore.log(e);
                }
                continue;
            }
            try {
                File file = new File(url.toURI());
                locations.add(new ClasspathElementDirectory(file));
                usedURLs.add(url);
            }
            catch (Exception e) {
                SpringCore.log(e);
            }
        }
        return new BytecodeTypeHierarchyClassReader(locations.toArray(new ClasspathElement[locations.size()]));
    }
}

