/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java.typehierarchy;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.java.typehierarchy.ClasspathElement;
import org.springframework.ide.eclipse.core.java.typehierarchy.TypeHierarchyClassReader;
import org.springframework.ide.eclipse.core.java.typehierarchy.TypeHierarchyElement;

public class BytecodeTypeHierarchyClassReader
implements TypeHierarchyClassReader {
    private ClasspathElement[] paths;

    public BytecodeTypeHierarchyClassReader(ClasspathElement[] locations) {
        this.paths = locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TypeHierarchyElement readTypeHierarchyInformation(char[] fullyQualifiedClassName, IProject project) {
        String fullyQualifiedClassFileName = String.valueOf(new String(fullyQualifiedClassName)) + ".class";
        String packageName = null;
        String className = null;
        int lastIndexOf = fullyQualifiedClassFileName.lastIndexOf(47);
        if (lastIndexOf > -1) {
            packageName = fullyQualifiedClassFileName.substring(0, lastIndexOf);
            className = fullyQualifiedClassFileName.substring(lastIndexOf + 1);
        } else {
            packageName = "";
            className = fullyQualifiedClassFileName;
        }
        int i = 0;
        while (i < this.paths.length) {
            InputStream stream = null;
            ClasspathElement classpathElement = this.paths[i];
            synchronized (classpathElement) {
                try {
                    stream = this.paths[i].getStream(fullyQualifiedClassFileName, packageName, className);
                    if (stream != null) {
                        TypeHierarchyElement typeHierarchyElement = this.readTypeHierarchy(stream);
                        return typeHierarchyElement;
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            SpringCore.log(e);
                        }
                    }
                }
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        int i = 0;
        while (i < this.paths.length) {
            ClasspathElement classpathElement = this.paths[i];
            synchronized (classpathElement) {
                this.paths[i].cleanup();
            }
            ++i;
        }
    }

    public TypeHierarchyElement readTypeHierarchy(InputStream stream) {
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(stream));
            int magic = dis.readInt();
            if (magic != -889275714) {
                throw new IllegalStateException("not bytecode, magic was 0x" + Integer.toString(magic, 16));
            }
            this.skip(dis, 4L);
            int constantPoolCount = dis.readShort();
            Object[] constantPoolData = new Object[constantPoolCount];
            int i = 1;
            while (i < constantPoolCount) {
                byte tag = dis.readByte();
                switch (tag) {
                    case 1: {
                        constantPoolData[i] = dis.readUTF();
                        break;
                    }
                    case 3: {
                        this.skip(dis, 4L);
                        break;
                    }
                    case 4: {
                        this.skip(dis, 4L);
                        break;
                    }
                    case 5: {
                        this.skip(dis, 8L);
                        ++i;
                        break;
                    }
                    case 6: {
                        this.skip(dis, 8L);
                        ++i;
                        break;
                    }
                    case 7: {
                        constantPoolData[i] = dis.readShort();
                        break;
                    }
                    case 8: {
                        this.skip(dis, 2L);
                        break;
                    }
                    case 9: {
                        this.skip(dis, 4L);
                        break;
                    }
                    case 10: {
                        this.skip(dis, 4L);
                        break;
                    }
                    case 11: {
                        this.skip(dis, 4L);
                        break;
                    }
                    case 12: {
                        this.skip(dis, 4L);
                        break;
                    }
                    case 15: {
                        this.skip(dis, 3L);
                        break;
                    }
                    case 16: {
                        this.skip(dis, 2L);
                        break;
                    }
                    case 18: {
                        this.skip(dis, 4L);
                    }
                }
                ++i;
            }
            this.skip(dis, 2L);
            short classNameIndex = dis.readShort();
            short classNameUTF8index = (Short)constantPoolData[classNameIndex];
            char[] className = ((String)constantPoolData[classNameUTF8index]).toCharArray();
            short superclassNameIndex = dis.readShort();
            char[] superclassName = null;
            if (superclassNameIndex != 0) {
                short superclassNameUTF8index = (Short)constantPoolData[superclassNameIndex];
                superclassName = ((String)constantPoolData[superclassNameUTF8index]).toCharArray();
            }
            int interfacesCount = dis.readShort();
            char[][] interfaceNames = null;
            if (interfacesCount != 0) {
                interfaceNames = new char[interfacesCount][];
                int i2 = 0;
                while (i2 < interfacesCount) {
                    short interfaceNameIndex = dis.readShort();
                    short interfaceNameUTF8index = (Short)constantPoolData[interfaceNameIndex];
                    interfaceNames[i2] = ((String)constantPoolData[interfaceNameUTF8index]).toCharArray();
                    ++i2;
                }
            }
            return new TypeHierarchyElement(className, superclassName, interfaceNames);
        }
        catch (Exception e) {
            SpringCore.log(e);
            return null;
        }
    }

    private void skip(InputStream stream, long n) throws IOException {
        long skipped;
        long bytesToSkip = n;
        while ((bytesToSkip -= (skipped = stream.skip(bytesToSkip))) > 0L) {
        }
    }
}

