/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java.classreading;

import java.io.IOException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.springframework.core.io.Resource;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.java.classreading.JdtConnectedMetadataReader;
import org.springframework.ide.eclipse.core.java.classreading.JdtMetadataReaderException;
import org.springframework.ide.eclipse.core.type.asm.CachingClassReaderFactory;

public class JdtMetadataReaderFactory
implements MetadataReaderFactory {
    private final IJavaProject project;
    private final ClassLoader classloader;
    private final CachingClassReaderFactory classReaderFactory;

    public JdtMetadataReaderFactory(IJavaProject project, ClassLoader classloader) {
        this.project = project;
        this.classloader = classloader;
        this.classReaderFactory = new CachingClassReaderFactory(this.classloader);
    }

    public MetadataReader getMetadataReader(String className) throws IOException {
        int ix;
        IType type = JdtUtils.getJavaType(this.project.getProject(), className);
        if (type == null && !className.contains("$") && (ix = className.lastIndexOf(46)) > 1) {
            className = String.valueOf(className.substring(0, ix)) + "$" + className.substring(ix + 1, className.length());
            type = JdtUtils.getJavaType(this.project.getProject(), className);
        }
        if (type == null) {
            throw new IOException("Could not find " + className);
        }
        return new JdtConnectedMetadataReader(type, this.classReaderFactory, this.classloader);
    }

    public MetadataReader getMetadataReader(Resource resource) throws IOException {
        throw new JdtMetadataReaderException("'getMetadataReader' is not supported");
    }
}

