/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.core.java.ParameterMethodFilter;

public class FlagsMethodFilter
extends ParameterMethodFilter {
    public static final int PUBLIC = 4;
    public static final int PRIVATE = 8;
    public static final int PROTECTED = 16;
    public static final int ABSTRACT = 32;
    public static final int NOT_ABSTRACT = 64;
    public static final int VOID = 128;
    public static final int NOT_VOID = 256;
    public static final int FINAL = 512;
    public static final int NOT_FINAL = 1024;
    public static final int INTERFACE = 2048;
    public static final int NOT_INTERFACE = 4096;
    public static final int CONSTRUCTOR = 8192;
    public static final int NOT_CONSTRUCTOR = 16384;
    public static final int STATIC = 32768;
    public static final int NOT_STATIC = 65536;
    private final int flags;

    public FlagsMethodFilter(int flags) {
        this.flags = flags;
    }

    public FlagsMethodFilter(int flags, String[] parameterTypes) {
        super(parameterTypes);
        this.flags = flags;
    }

    public FlagsMethodFilter(int flags, String returnType, String[] parameterTypes) {
        super(returnType, parameterTypes);
        this.flags = flags;
    }

    public FlagsMethodFilter(int flags, String returnType) {
        super(returnType);
        this.flags = flags;
    }

    public FlagsMethodFilter(int flags, int parameterCount) {
        super(parameterCount);
        this.flags = flags;
    }

    public FlagsMethodFilter(int flags, String returnType, int parameterCount) {
        super(returnType, parameterCount);
        this.flags = flags;
    }

    public boolean matches(IMethod method, String prefix) {
        return super.matches(method, prefix) && this.matchesFlags(method);
    }

    private boolean matchesFlags(IMethod method) {
        int methodFlags;
        block31: {
            block30: {
                block29: {
                    block28: {
                        block27: {
                            block26: {
                                block25: {
                                    block24: {
                                        block23: {
                                            block22: {
                                                block21: {
                                                    block20: {
                                                        block19: {
                                                            block18: {
                                                                block17: {
                                                                    try {
                                                                        methodFlags = method.getFlags();
                                                                        if (method.exists()) break block17;
                                                                        return false;
                                                                    }
                                                                    catch (JavaModelException javaModelException) {
                                                                        return false;
                                                                    }
                                                                }
                                                                if ((this.flags & 4) == 0 || Flags.isPublic((int)methodFlags)) break block18;
                                                                return false;
                                                            }
                                                            if ((this.flags & 0x10) == 0 || Flags.isProtected((int)methodFlags)) break block19;
                                                            return false;
                                                        }
                                                        if ((this.flags & 8) == 0 || Flags.isPrivate((int)methodFlags)) break block20;
                                                        return false;
                                                    }
                                                    if ((this.flags & 0x20) == 0 || Flags.isAbstract((int)methodFlags)) break block21;
                                                    return false;
                                                }
                                                if ((this.flags & 0x40) == 0 || !Flags.isAbstract((int)methodFlags)) break block22;
                                                return false;
                                            }
                                            if ((this.flags & 0x80) == 0 || "V".equals(method.getReturnType())) break block23;
                                            return false;
                                        }
                                        if ((this.flags & 0x100) == 0 || !"V".equals(method.getReturnType())) break block24;
                                        return false;
                                    }
                                    if ((this.flags & 0x200) == 0 || Flags.isFinal((int)methodFlags)) break block25;
                                    return false;
                                }
                                if ((this.flags & 0x400) == 0 || !Flags.isFinal((int)methodFlags)) break block26;
                                return false;
                            }
                            if ((this.flags & 0x800) == 0 || Flags.isInterface((int)methodFlags)) break block27;
                            return false;
                        }
                        if ((this.flags & 0x1000) == 0 || !Flags.isInterface((int)methodFlags)) break block28;
                        return false;
                    }
                    if ((this.flags & 0x2000) == 0 || method.isConstructor()) break block29;
                    return false;
                }
                if ((this.flags & 0x4000) == 0 || !method.isConstructor()) break block30;
                return false;
            }
            if ((this.flags & 0x8000) == 0 || Flags.isStatic((int)methodFlags)) break block31;
            return false;
        }
        return (this.flags & 0x10000) == 0 || !Flags.isStatic((int)methodFlags);
    }
}

