/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.FileLocator;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtils {
    public static final String CLASS_FILE_SUFFIX = ".class";

    public static String getClassFileName(String className) {
        className = StringUtils.replace((String)className, (String)".", (String)"/");
        return String.valueOf(className) + CLASS_FILE_SUFFIX;
    }

    public static String getClassLoaderHierachy(Class clazz) {
        ClassLoader cls = clazz.getClassLoader();
        StringBuffer buf = new StringBuffer(cls.getClass().getName());
        while (cls.getParent() != null) {
            cls = cls.getParent();
            buf.append(" -> ");
            buf.append(cls.getClass().getName());
        }
        return buf.toString();
    }

    public static String getClassLocation(Class clazz) {
        Assert.notNull((Object)clazz);
        String resourceName = org.springframework.util.ClassUtils.getClassFileName((Class)clazz);
        String location = null;
        try {
            URL nativeUrl;
            URL url = clazz.getResource(resourceName);
            if (url != null && (nativeUrl = FileLocator.resolve((URL)url)) != null) {
                location = nativeUrl.getFile();
            }
        }
        catch (IOException iOException) {}
        if (location != null) {
            int ix = location.lastIndexOf(33);
            location = location.substring(0, ix);
        }
        return location;
    }

    public static String getClassVersion(Class clazz) {
        String version = "unkown";
        if (clazz.getPackage().getImplementationVersion() != null) {
            version = clazz.getPackage().getImplementationVersion();
        }
        return version;
    }

    public static Object invokeMethod(Object target, String methodName, Object ... parameters) throws Throwable {
        if (target == null) {
            return null;
        }
        if (parameters != null && parameters.length > 0) {
            ArrayList parameterClasses = new ArrayList();
            Object[] objectArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Object parameter = objectArray[n2];
                parameterClasses.add(parameter.getClass());
                ++n2;
            }
            return ClassUtils.invokeMethod(target, methodName, parameters, parameterClasses.toArray(new Class[parameterClasses.size()]));
        }
        return ClassUtils.invokeMethod(target, methodName, parameters, new Class[0]);
    }

    public static Object invokeMethod(Object target, String methodName, Object[] parameters, Class[] parameterClasses) throws Throwable {
        Method targetMethod;
        if (target == null) {
            return null;
        }
        Class targetClass = target.getClass();
        if (target instanceof Class) {
            targetClass = (Class)target;
        }
        if ((targetMethod = ReflectionUtils.findMethod((Class)targetClass, (String)methodName, (Class[])parameterClasses)) != null) {
            ReflectionUtils.makeAccessible((Method)targetMethod);
            if (target instanceof Class) {
                return ReflectionUtils.invokeMethod((Method)targetMethod, null, (Object[])parameters);
            }
            return ReflectionUtils.invokeMethod((Method)targetMethod, (Object)target, (Object[])parameters);
        }
        return null;
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return ClassUtils.loadClass(className, loader);
    }

    public static Class<?> loadClass(Class clazz) throws ClassNotFoundException {
        return ClassUtils.loadClass(clazz.getName());
    }

    public static Class<?> loadClass(String className, ClassLoader loader) throws ClassNotFoundException {
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            int lastDotIndex = className.lastIndexOf(46);
            if (lastDotIndex != -1) {
                String innerClassName = String.valueOf(className.substring(0, lastDotIndex)) + '$' + className.substring(lastDotIndex + 1);
                try {
                    return loader.loadClass(innerClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            throw ex;
        }
    }
}

