/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.ide.eclipse.core.io.EclipsePathMatchingResourcePatternResolver;
import org.springframework.ide.eclipse.core.io.ExternalFile;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.util.ObjectUtils;

public class FileResource
extends AbstractResource
implements IAdaptable {
    private IFile file;

    public FileResource(IFile file) {
        this.file = file;
    }

    public FileResource(String path) {
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Path '" + path + "' has to be relative to Eclipse workspace");
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource member = root.findMember(path);
        if (member != null && member instanceof IFile) {
            this.file = (IFile)member;
        }
    }

    public boolean exists() {
        return this.file != null && this.file.exists();
    }

    public InputStream getInputStream() throws IOException {
        if (this.file == null) {
            throw new FileNotFoundException("File not found");
        }
        if (this.file instanceof ExternalFile) {
            try {
                return this.file.getContents();
            }
            catch (CoreException e) {
                throw new IOException(e.getMessage());
            }
        }
        return new FileInputStream(this.getFile());
    }

    public URL getURL() throws IOException {
        if (this.file == null) {
            throw new FileNotFoundException("File not found");
        }
        return new URL("file:" + this.file.getRawLocation());
    }

    public File getFile() throws IOException {
        if (this.file == null) {
            throw new FileNotFoundException("File not found");
        }
        return this.file.getLocation().toFile();
    }

    public Resource createRelative(String relativePath) throws IOException {
        if (this.file == null) {
            throw new IllegalStateException("File not found");
        }
        IFile relativeFile = this.file.getParent().getFile((IPath)new Path(relativePath));
        if (relativeFile != null && relativeFile.exists()) {
            return new FileResource(relativeFile);
        }
        if (JdtUtils.isJavaProject((IResource)this.file)) {
            try {
                IPath filePath = this.file.getFullPath();
                IPath newPath = null;
                IClasspathEntry[] iClasspathEntryArray = JdtUtils.getJavaProject((IResource)this.file).getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3 && entry.getPath().isPrefixOf(filePath)) {
                        newPath = filePath.removeFirstSegments(entry.getPath().segmentCount());
                        break;
                    }
                    ++n2;
                }
                if (newPath != null) {
                    newPath = newPath.removeLastSegments(1).append(relativePath);
                    return new EclipsePathMatchingResourcePatternResolver(this.file.getProject()).getResource(newPath.toString());
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        throw new FileNotFoundException("Cannot create relative resource '" + relativePath + "' for " + this.getDescription());
    }

    public String getFilename() {
        if (this.file == null) {
            throw new IllegalStateException("File not found");
        }
        if (this.file instanceof ExternalFile) {
            return ((ExternalFile)this.file).getFilename();
        }
        return this.file.getProjectRelativePath().toString();
    }

    public String getDescription() {
        return "file [" + (this.file != null ? this.file.getRawLocation() : "") + "]";
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IResource.class) || adapter.equals(IFile.class)) {
            return this.file;
        }
        return null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileResource)) {
            return false;
        }
        FileResource that = (FileResource)((Object)other);
        return ObjectUtils.nullSafeEquals((Object)this.file, (Object)that.file);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.file);
    }

    public IFile getRawFile() {
        return this.file;
    }
}

