/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.internal.model.resources;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.internal.model.resources.ISpringResourceChangeEvents;
import org.springframework.ide.eclipse.core.java.JdtUtils;

public class SpringResourceChangeListener
implements IResourceChangeListener {
    public static final int LISTENER_FLAGS = 62;
    private static final int VISITOR_FLAGS = 7;
    private ISpringResourceChangeEvents events;

    public SpringResourceChangeListener(ISpringResourceChangeEvents events) {
        this.events = events;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        block21: {
            block20: {
                if (!(event.getSource() instanceof IWorkspace)) break block20;
                int eventType = event.getType();
                switch (eventType) {
                    case 2: {
                        IProject closedProject = (IProject)event.getResource();
                        if (SpringCoreUtils.isSpringProject((IResource)closedProject)) {
                            this.events.projectClosed(closedProject, eventType);
                            break;
                        }
                        break block21;
                    }
                    case 4: {
                        IProject openedProject = (IProject)event.getResource();
                        if (SpringCoreUtils.isSpringProject((IResource)openedProject)) {
                            this.events.projectDeleted(openedProject, eventType);
                            break;
                        }
                        break block21;
                    }
                    case 8: 
                    case 16: 
                    case 32: {
                        IResourceDelta delta = event.getDelta();
                        if (delta == null) break block21;
                        try {
                            delta.accept(this.getVisitor(eventType), 7);
                            break;
                        }
                        catch (CoreException e) {
                            SpringCore.log("Error while traversing resource change delta", e);
                        }
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block21;
            }
            if (event.getSource() instanceof IProject) {
                int eventType = event.getType();
                switch (eventType) {
                    case 2: {
                        IProject closedProject = (IProject)event.getSource();
                        if (!SpringCoreUtils.isSpringProject((IResource)closedProject)) break;
                        this.events.projectClosed(closedProject, eventType);
                        break;
                    }
                    case 4: {
                        IProject openedProject = (IProject)event.getSource();
                        if (!SpringCoreUtils.isSpringProject((IResource)openedProject)) break;
                        this.events.projectDeleted(openedProject, eventType);
                        break;
                    }
                    case 8: 
                    case 16: {
                        IResourceDelta delta = event.getDelta();
                        if (delta == null) break;
                        try {
                            delta.accept(this.getVisitor(eventType), 7);
                            break;
                        }
                        catch (CoreException e) {
                            SpringCore.log("Error while traversing resource change delta", e);
                        }
                    }
                }
            }
        }
    }

    protected IResourceDeltaVisitor getVisitor(int eventType) {
        return new SpringResourceVisitor(eventType);
    }

    protected class SpringResourceVisitor
    implements IResourceDeltaVisitor {
        protected int eventType;

        public SpringResourceVisitor(int eventType) {
            this.eventType = eventType;
        }

        public final boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    return this.resourceAdded(resource);
                }
                case 16384: {
                    return this.resourceOpened(resource);
                }
                case 4: {
                    return this.resourceChanged(resource, delta.getFlags());
                }
                case 2: {
                    return this.resourceRemoved(resource);
                }
            }
            return true;
        }

        protected boolean resourceAdded(final IResource resource) {
            if (resource instanceof IProject) {
                if (SpringCoreUtils.isSpringProject(resource)) {
                    if (resource.isSynchronized(2)) {
                        SpringResourceChangeListener.this.events.projectAdded((IProject)resource, this.eventType);
                    } else {
                        Job projectAddJob = new Job("Importing project configuration for '" + resource.getName() + "'"){

                            protected IStatus run(IProgressMonitor monitor) {
                                if (!resource.isSynchronized(2)) {
                                    try {
                                        resource.refreshLocal(2, monitor);
                                    }
                                    catch (CoreException e) {
                                        SpringCore.log(e);
                                    }
                                }
                                SpringResourceChangeListener.this.events.projectAdded((IProject)resource, SpringResourceVisitor.this.eventType);
                                SpringCoreUtils.buildFullProject((IProject)resource);
                                return Status.OK_STATUS;
                            }
                        };
                        projectAddJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().refreshRule(resource));
                        projectAddJob.setPriority(10);
                        projectAddJob.setSystem(true);
                        projectAddJob.schedule();
                    }
                }
                return false;
            }
            return true;
        }

        protected boolean resourceOpened(IResource resource) {
            if (resource instanceof IProject) {
                if (SpringCoreUtils.isSpringProject(resource)) {
                    SpringResourceChangeListener.this.events.projectOpened((IProject)resource, this.eventType);
                }
                return false;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected boolean resourceChanged(IResource resource, int flags) {
            if (resource instanceof IProject) {
                if ((flags & 0x4000) != 0) {
                    if (!SpringCoreUtils.isSpringProject(resource)) return false;
                    SpringResourceChangeListener.this.events.projectOpened((IProject)resource, this.eventType);
                    return false;
                }
                if ((flags & 0x80000) == 0) return true;
                IProject project = (IProject)resource;
                if (SpringCoreUtils.isSpringProject((IResource)project)) {
                    if (SpringResourceChangeListener.this.events.isSpringProject((IProject)resource, this.eventType)) return false;
                    SpringResourceChangeListener.this.events.springNatureAdded(project, this.eventType);
                    return false;
                }
                if (!SpringResourceChangeListener.this.events.isSpringProject(project, this.eventType)) return false;
                SpringResourceChangeListener.this.events.springNatureRemoved(project, this.eventType);
                return false;
            }
            if (!(resource instanceof IFolder)) return true;
            if (!JdtUtils.isJavaProject(resource)) return true;
            try {
                IJavaProject jp = JdtUtils.getJavaProject(resource);
                if (!this.checkPathForNonOutputLocation(jp.getOutputLocation(), resource)) {
                    return false;
                }
                IClasspathEntry[] iClasspathEntryArray = jp.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return true;
                    }
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3 && !this.checkPathForNonOutputLocation(entry.getOutputLocation(), resource)) {
                        return false;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                SpringCore.log(e);
            }
            return true;
        }

        protected boolean resourceRemoved(IResource resource) {
            return true;
        }

        protected boolean checkPathForNonOutputLocation(IPath path, IResource resource) {
            return path == null || !(path = path.removeFirstSegments(1)).isPrefixOf(resource.getProjectRelativePath());
        }
    }
}

